@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.alicloud.cloudsso.ScimServerCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud SSO SCIM Server Credential resource.
 * For information about Cloud SSO SCIM Server Credential and how to use it, see [What is Cloud SSO SCIM Server Credential](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-createscimservercredential).
 * > **NOTE:** Available since v1.138.0.
 * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
 * ## Import
 * Cloud SSO SCIM Server Credential can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/scimServerCredential:ScimServerCredential example <directory_id>:<credential_id>
 * ```
 * @property directoryId The ID of the Directory.
 * @property status The Status of the resource. Valid values: `Disabled`, `Enabled`.
 */
public data class ScimServerCredentialArgs(
    public val directoryId: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.ScimServerCredentialArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.ScimServerCredentialArgs =
        com.pulumi.alicloud.cloudsso.ScimServerCredentialArgs.builder()
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScimServerCredentialArgs].
 */
@PulumiTagMarker
public class ScimServerCredentialArgsBuilder internal constructor() {
    private var directoryId: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("epqlokqpstfvobio")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value The Status of the resource. Valid values: `Disabled`, `Enabled`.
     */
    @JvmName("idywwxfburmcsgmd")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("jvyatohkxsaqivpu")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value The Status of the resource. Valid values: `Disabled`, `Enabled`.
     */
    @JvmName("rljnbfijojwnrdky")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ScimServerCredentialArgs = ScimServerCredentialArgs(
        directoryId = directoryId,
        status = status,
    )
}
