@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.alicloud.cloudsso.UserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud SSO User resource.
 * For information about Cloud SSO User and how to use it, see [What is User](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-createuser).
 * > **NOTE:** Available since v1.140.0.
 * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
 * ## Import
 * Cloud SSO User can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/user:User example <directory_id>:<user_id>
 * ```
 * @property description The description of user. The description can be up to `1024` characters long.
 * @property directoryId The ID of the Directory.
 * @property displayName The display name of user. The display name can be up to `256` characters long.
 * @property email The User's Contact Email Address. The email can be up to `128` characters long.
 * @property firstName The first name of user. The first_name can be up to `64` characters long.
 * @property lastName The last name of user. The last_name can be up to `64` characters long.
 * @property status The status of user. Valid values: `Disabled`, `Enabled`.
 * @property userName The name of user. The name must be `1` to `64` characters in length and can contain letters, digits, at signs (@), periods (.), underscores (_), and hyphens (-).
 */
public data class UserArgs(
    public val description: Output<String>? = null,
    public val directoryId: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val email: Output<String>? = null,
    public val firstName: Output<String>? = null,
    public val lastName: Output<String>? = null,
    public val status: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.UserArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.UserArgs =
        com.pulumi.alicloud.cloudsso.UserArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .firstName(firstName?.applyValue({ args0 -> args0 }))
            .lastName(lastName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var directoryId: Output<String>? = null

    private var displayName: Output<String>? = null

    private var email: Output<String>? = null

    private var firstName: Output<String>? = null

    private var lastName: Output<String>? = null

    private var status: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The description of user. The description can be up to `1024` characters long.
     */
    @JvmName("iirljxylgduttesa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("welpowwrfxonswdb")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value The display name of user. The display name can be up to `256` characters long.
     */
    @JvmName("jrfwpdqrjeafcajr")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The User's Contact Email Address. The email can be up to `128` characters long.
     */
    @JvmName("leivdiggqyrtckdl")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The first name of user. The first_name can be up to `64` characters long.
     */
    @JvmName("rgiatrwwqwhfrybi")
    public suspend fun firstName(`value`: Output<String>) {
        this.firstName = value
    }

    /**
     * @param value The last name of user. The last_name can be up to `64` characters long.
     */
    @JvmName("xractvagpgbvxtud")
    public suspend fun lastName(`value`: Output<String>) {
        this.lastName = value
    }

    /**
     * @param value The status of user. Valid values: `Disabled`, `Enabled`.
     */
    @JvmName("lqjgisbaqaabphcr")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of user. The name must be `1` to `64` characters in length and can contain letters, digits, at signs (@), periods (.), underscores (_), and hyphens (-).
     */
    @JvmName("gikdnmlqdunnohmo")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The description of user. The description can be up to `1024` characters long.
     */
    @JvmName("ouqrrhxjoqkkqljj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("ujqsgwedjegqbutr")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value The display name of user. The display name can be up to `256` characters long.
     */
    @JvmName("qbucnphmcbdpgrng")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The User's Contact Email Address. The email can be up to `128` characters long.
     */
    @JvmName("vsppccbrokhskugs")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The first name of user. The first_name can be up to `64` characters long.
     */
    @JvmName("dkudbkbylqsquamm")
    public suspend fun firstName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstName = mapped
    }

    /**
     * @param value The last name of user. The last_name can be up to `64` characters long.
     */
    @JvmName("elglxwusaeuqemle")
    public suspend fun lastName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastName = mapped
    }

    /**
     * @param value The status of user. Valid values: `Disabled`, `Enabled`.
     */
    @JvmName("yqeijmdalmsqrotf")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The name of user. The name must be `1` to `64` characters in length and can contain letters, digits, at signs (@), periods (.), underscores (_), and hyphens (-).
     */
    @JvmName("andeewykvaiqfgyc")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        description = description,
        directoryId = directoryId,
        displayName = displayName,
        email = email,
        firstName = firstName,
        lastName = lastName,
        status = status,
        userName = userName,
    )
}
