@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserAttachment].
 */
@PulumiTagMarker
public class UserAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserAttachmentArgs = UserAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserAttachmentArgsBuilder.() -> Unit) {
        val builder = UserAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserAttachment {
        val builtJavaResource = com.pulumi.alicloud.cloudsso.UserAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserAttachment(builtJavaResource)
    }
}

/**
 * Provides a Cloud SSO User Attachment resource.
 * For information about Cloud SSO User Attachment and how to use it, see [What is User Attachment](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-addusertogroup).
 * > **NOTE:** Available since v1.141.0.
 * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
 * ## Import
 * Cloud SSO User Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/userAttachment:UserAttachment example <directory_id>:<group_id>:<user_id>
 * ```
 */
public class UserAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudsso.UserAttachment,
) : KotlinCustomResource(javaResource, UserAttachmentMapper) {
    /**
     * The ID of the Directory.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * The Group ID.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * The User ID.
     */
    public val userId: Output<String>
        get() = javaResource.userId().applyValue({ args0 -> args0 })
}

public object UserAttachmentMapper : ResourceMapper<UserAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudsso.UserAttachment::class == javaResource::class

    override fun map(javaResource: Resource): UserAttachment = UserAttachment(
        javaResource as
            com.pulumi.alicloud.cloudsso.UserAttachment,
    )
}

/**
 * @see [UserAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserAttachment].
 */
public suspend fun userAttachment(
    name: String,
    block: suspend UserAttachmentResourceBuilder.() -> Unit,
): UserAttachment {
    val builder = UserAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userAttachment(name: String): UserAttachment {
    val builder = UserAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
