@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin

import com.pulumi.alicloud.cloudsso.UserAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud SSO User Attachment resource.
 * For information about Cloud SSO User Attachment and how to use it, see [What is User Attachment](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-addusertogroup).
 * > **NOTE:** Available since v1.141.0.
 * > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region
 * ## Import
 * Cloud SSO User Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudsso/userAttachment:UserAttachment example <directory_id>:<group_id>:<user_id>
 * ```
 * @property directoryId The ID of the Directory.
 * @property groupId The Group ID.
 * @property userId The User ID.
 */
public data class UserAttachmentArgs(
    public val directoryId: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val userId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.UserAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.UserAttachmentArgs =
        com.pulumi.alicloud.cloudsso.UserAttachmentArgs.builder()
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAttachmentArgs].
 */
@PulumiTagMarker
public class UserAttachmentArgsBuilder internal constructor() {
    private var directoryId: Output<String>? = null

    private var groupId: Output<String>? = null

    private var userId: Output<String>? = null

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("tftiwvrjaqfowwuc")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value The Group ID.
     */
    @JvmName("rynangiwlblwubhq")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The User ID.
     */
    @JvmName("whofdujypjfguumm")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("xbxcrxblnvoqanxg")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value The Group ID.
     */
    @JvmName("rxxwfdmrcfrslpqh")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The User ID.
     */
    @JvmName("kmbrsvmhyjgtlwtd")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): UserAttachmentArgs = UserAttachmentArgs(
        directoryId = directoryId,
        groupId = groupId,
        userId = userId,
    )
}
