@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.inputs

import com.pulumi.alicloud.cloudsso.inputs.AccessConfigurationPermissionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property permissionPolicyDocument The Content of Policy.
 * @property permissionPolicyName The Policy Name of policy. The name of the resource.
 * @property permissionPolicyType The Policy Type of policy. Valid values: `System`, `Inline`.
 */
public data class AccessConfigurationPermissionPolicyArgs(
    public val permissionPolicyDocument: Output<String>? = null,
    public val permissionPolicyName: Output<String>,
    public val permissionPolicyType: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.inputs.AccessConfigurationPermissionPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.inputs.AccessConfigurationPermissionPolicyArgs = com.pulumi.alicloud.cloudsso.inputs.AccessConfigurationPermissionPolicyArgs.builder()
        .permissionPolicyDocument(permissionPolicyDocument?.applyValue({ args0 -> args0 }))
        .permissionPolicyName(permissionPolicyName.applyValue({ args0 -> args0 }))
        .permissionPolicyType(permissionPolicyType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessConfigurationPermissionPolicyArgs].
 */
@PulumiTagMarker
public class AccessConfigurationPermissionPolicyArgsBuilder internal constructor() {
    private var permissionPolicyDocument: Output<String>? = null

    private var permissionPolicyName: Output<String>? = null

    private var permissionPolicyType: Output<String>? = null

    /**
     * @param value The Content of Policy.
     */
    @JvmName("puqwjvwyqwrtobal")
    public suspend fun permissionPolicyDocument(`value`: Output<String>) {
        this.permissionPolicyDocument = value
    }

    /**
     * @param value The Policy Name of policy. The name of the resource.
     */
    @JvmName("jwnmjrqyegftpmbx")
    public suspend fun permissionPolicyName(`value`: Output<String>) {
        this.permissionPolicyName = value
    }

    /**
     * @param value The Policy Type of policy. Valid values: `System`, `Inline`.
     */
    @JvmName("yxheauegtdobvmgr")
    public suspend fun permissionPolicyType(`value`: Output<String>) {
        this.permissionPolicyType = value
    }

    /**
     * @param value The Content of Policy.
     */
    @JvmName("djhnvsmhnegcgfrc")
    public suspend fun permissionPolicyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionPolicyDocument = mapped
    }

    /**
     * @param value The Policy Name of policy. The name of the resource.
     */
    @JvmName("dxedopqfecegjgvv")
    public suspend fun permissionPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissionPolicyName = mapped
    }

    /**
     * @param value The Policy Type of policy. Valid values: `System`, `Inline`.
     */
    @JvmName("egtfxrfvtdaosmfo")
    public suspend fun permissionPolicyType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissionPolicyType = mapped
    }

    internal fun build(): AccessConfigurationPermissionPolicyArgs =
        AccessConfigurationPermissionPolicyArgs(
            permissionPolicyDocument = permissionPolicyDocument,
            permissionPolicyName = permissionPolicyName ?: throw
                PulumiNullFieldException("permissionPolicyName"),
            permissionPolicyType = permissionPolicyType ?: throw
                PulumiNullFieldException("permissionPolicyType"),
        )
}
