@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.inputs

import com.pulumi.alicloud.cloudsso.inputs.DirectorySamlIdentityProviderConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property encodedMetadataDocument Base64 encoded IdP metadata document. **NOTE:** If the IdP Metadata has been uploaded, no update will be made if this parameter is not specified, otherwise the update will be made according to the parameter content. If IdP Metadata has not been uploaded, and the parameter `sso_status` is `Enabled`, this parameter must be provided. If the IdP Metadata has not been uploaded, and the parameter `sso_status` is `Disabled`, this parameter can be omitted, and the IdP Metadata will remain empty.
 * @property ssoStatus SAML SSO login enabled status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
 */
public data class DirectorySamlIdentityProviderConfigurationArgs(
    public val encodedMetadataDocument: Output<String>? = null,
    public val ssoStatus: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cloudsso.inputs.DirectorySamlIdentityProviderConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.inputs.DirectorySamlIdentityProviderConfigurationArgs =
        com.pulumi.alicloud.cloudsso.inputs.DirectorySamlIdentityProviderConfigurationArgs.builder()
            .encodedMetadataDocument(encodedMetadataDocument?.applyValue({ args0 -> args0 }))
            .ssoStatus(ssoStatus?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DirectorySamlIdentityProviderConfigurationArgs].
 */
@PulumiTagMarker
public class DirectorySamlIdentityProviderConfigurationArgsBuilder internal constructor() {
    private var encodedMetadataDocument: Output<String>? = null

    private var ssoStatus: Output<String>? = null

    /**
     * @param value Base64 encoded IdP metadata document. **NOTE:** If the IdP Metadata has been uploaded, no update will be made if this parameter is not specified, otherwise the update will be made according to the parameter content. If IdP Metadata has not been uploaded, and the parameter `sso_status` is `Enabled`, this parameter must be provided. If the IdP Metadata has not been uploaded, and the parameter `sso_status` is `Disabled`, this parameter can be omitted, and the IdP Metadata will remain empty.
     */
    @JvmName("ojugegffvcqrhiny")
    public suspend fun encodedMetadataDocument(`value`: Output<String>) {
        this.encodedMetadataDocument = value
    }

    /**
     * @param value SAML SSO login enabled status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
     */
    @JvmName("xhrlfufwmshjqhsm")
    public suspend fun ssoStatus(`value`: Output<String>) {
        this.ssoStatus = value
    }

    /**
     * @param value Base64 encoded IdP metadata document. **NOTE:** If the IdP Metadata has been uploaded, no update will be made if this parameter is not specified, otherwise the update will be made according to the parameter content. If IdP Metadata has not been uploaded, and the parameter `sso_status` is `Enabled`, this parameter must be provided. If the IdP Metadata has not been uploaded, and the parameter `sso_status` is `Disabled`, this parameter can be omitted, and the IdP Metadata will remain empty.
     */
    @JvmName("wsoammanumpxgsxj")
    public suspend fun encodedMetadataDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodedMetadataDocument = mapped
    }

    /**
     * @param value SAML SSO login enabled status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
     */
    @JvmName("gjqfycirlirdivlx")
    public suspend fun ssoStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssoStatus = mapped
    }

    internal fun build(): DirectorySamlIdentityProviderConfigurationArgs =
        DirectorySamlIdentityProviderConfigurationArgs(
            encodedMetadataDocument = encodedMetadataDocument,
            ssoStatus = ssoStatus,
        )
}
