@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.inputs

import com.pulumi.alicloud.cloudsso.inputs.GetAccessAssignmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccessAssignments.
 * @property accessConfigurationId Access configuration ID.
 * @property directoryId Directory ID.
 * @property ids A list of Access Assignment IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property principalType Create the identity type of the access assignment, which can be a user or a user group. Valid values: `Group`, `User`.
 * @property targetId The ID of the target to create the resource range.
 * @property targetType The type of the resource range target to be accessed. Only a single RD primary account or member account can be specified in the first phase. Valid values: `RD-Account`.
 */
public data class GetAccessAssignmentsPlainArgs(
    public val accessConfigurationId: String? = null,
    public val directoryId: String,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val principalType: String? = null,
    public val targetId: String? = null,
    public val targetType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.inputs.GetAccessAssignmentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.inputs.GetAccessAssignmentsPlainArgs =
        com.pulumi.alicloud.cloudsso.inputs.GetAccessAssignmentsPlainArgs.builder()
            .accessConfigurationId(accessConfigurationId?.let({ args0 -> args0 }))
            .directoryId(directoryId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .principalType(principalType?.let({ args0 -> args0 }))
            .targetId(targetId?.let({ args0 -> args0 }))
            .targetType(targetType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessAssignmentsPlainArgs].
 */
@PulumiTagMarker
public class GetAccessAssignmentsPlainArgsBuilder internal constructor() {
    private var accessConfigurationId: String? = null

    private var directoryId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var principalType: String? = null

    private var targetId: String? = null

    private var targetType: String? = null

    /**
     * @param value Access configuration ID.
     */
    @JvmName("fjqsxbuejxifvhwq")
    public suspend fun accessConfigurationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accessConfigurationId = mapped
    }

    /**
     * @param value Directory ID.
     */
    @JvmName("tavgetfdpdexsnkl")
    public suspend fun directoryId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.directoryId = mapped
    }

    /**
     * @param value A list of Access Assignment IDs.
     */
    @JvmName("keormpfvjappusbq")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Access Assignment IDs.
     */
    @JvmName("qtkwurdcwkwswqfo")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("arthigiktyunygcm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Create the identity type of the access assignment, which can be a user or a user group. Valid values: `Group`, `User`.
     */
    @JvmName("gevvtdargccigslv")
    public suspend fun principalType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.principalType = mapped
    }

    /**
     * @param value The ID of the target to create the resource range.
     */
    @JvmName("ohhwyfnhepmpyvwl")
    public suspend fun targetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.targetId = mapped
    }

    /**
     * @param value The type of the resource range target to be accessed. Only a single RD primary account or member account can be specified in the first phase. Valid values: `RD-Account`.
     */
    @JvmName("cvhtkidjihtdgfuo")
    public suspend fun targetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.targetType = mapped
    }

    internal fun build(): GetAccessAssignmentsPlainArgs = GetAccessAssignmentsPlainArgs(
        accessConfigurationId = accessConfigurationId,
        directoryId = directoryId ?: throw PulumiNullFieldException("directoryId"),
        ids = ids,
        outputFile = outputFile,
        principalType = principalType,
        targetId = targetId,
        targetType = targetType,
    )
}
