@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.inputs

import com.pulumi.alicloud.cloudsso.inputs.GetAccessConfigurationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccessConfigurations.
 * @property directoryId The ID of the Directory.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Access Configuration IDs.
 * @property nameRegex A regex string to filter results by Access Configuration name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetAccessConfigurationsPlainArgs(
    public val directoryId: String,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.inputs.GetAccessConfigurationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.inputs.GetAccessConfigurationsPlainArgs =
        com.pulumi.alicloud.cloudsso.inputs.GetAccessConfigurationsPlainArgs.builder()
            .directoryId(directoryId.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessConfigurationsPlainArgs].
 */
@PulumiTagMarker
public class GetAccessConfigurationsPlainArgsBuilder internal constructor() {
    private var directoryId: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("jpppqgxnascdrjgc")
    public suspend fun directoryId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.directoryId = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("rmcavdrdfxnexrcb")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Access Configuration IDs.
     */
    @JvmName("rmrjhltbugjscecg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Access Configuration IDs.
     */
    @JvmName("ggxdaatmwcfaoobd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Access Configuration name.
     */
    @JvmName("csrjxdoiyytyovig")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nxsgkojxxcfroqqo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetAccessConfigurationsPlainArgs = GetAccessConfigurationsPlainArgs(
        directoryId = directoryId ?: throw PulumiNullFieldException("directoryId"),
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
