@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.inputs

import com.pulumi.alicloud.cloudsso.inputs.GetGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroups.
 * @property directoryId The ID of the Directory.
 * @property ids A list of Group IDs.
 * @property nameRegex A regex string to filter results by Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property provisionType The ProvisionType of the Group. Valid values: `Manual`, `Synchronized`.
 */
public data class GetGroupsPlainArgs(
    public val directoryId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val provisionType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.inputs.GetGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.inputs.GetGroupsPlainArgs =
        com.pulumi.alicloud.cloudsso.inputs.GetGroupsPlainArgs.builder()
            .directoryId(directoryId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .provisionType(provisionType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetGroupsPlainArgsBuilder internal constructor() {
    private var directoryId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var provisionType: String? = null

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("gvjhnbksskpuuefy")
    public suspend fun directoryId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.directoryId = mapped
    }

    /**
     * @param value A list of Group IDs.
     */
    @JvmName("jvihrvvtvotxnpgs")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Group IDs.
     */
    @JvmName("okfdotcyvqiwgpwx")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Group name.
     */
    @JvmName("btwbwpauqkkwmbou")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dqvnnfvydjmjyydg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ProvisionType of the Group. Valid values: `Manual`, `Synchronized`.
     */
    @JvmName("xtqemqeqgrvpywtm")
    public suspend fun provisionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.provisionType = mapped
    }

    internal fun build(): GetGroupsPlainArgs = GetGroupsPlainArgs(
        directoryId = directoryId ?: throw PulumiNullFieldException("directoryId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        provisionType = provisionType,
    )
}
