@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.inputs

import com.pulumi.alicloud.cloudsso.inputs.GetScimServerCredentialsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getScimServerCredentials.
 * @property directoryId The ID of the Directory.
 * @property ids A list of SCIM Server Credential IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The Status of the resource. Valid values: `Disabled`, `Enabled`.
 */
public data class GetScimServerCredentialsPlainArgs(
    public val directoryId: String,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.inputs.GetScimServerCredentialsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.inputs.GetScimServerCredentialsPlainArgs =
        com.pulumi.alicloud.cloudsso.inputs.GetScimServerCredentialsPlainArgs.builder()
            .directoryId(directoryId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScimServerCredentialsPlainArgs].
 */
@PulumiTagMarker
public class GetScimServerCredentialsPlainArgsBuilder internal constructor() {
    private var directoryId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("vdbthbwuubyprmay")
    public suspend fun directoryId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.directoryId = mapped
    }

    /**
     * @param value A list of SCIM Server Credential IDs.
     */
    @JvmName("ksrvheqlsajncxjh")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of SCIM Server Credential IDs.
     */
    @JvmName("wccfeksfipravhtg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xkhhrtoawtrevlvx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Status of the resource. Valid values: `Disabled`, `Enabled`.
     */
    @JvmName("hxbpxpolkwrnnvsw")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetScimServerCredentialsPlainArgs = GetScimServerCredentialsPlainArgs(
        directoryId = directoryId ?: throw PulumiNullFieldException("directoryId"),
        ids = ids,
        outputFile = outputFile,
        status = status,
    )
}
