@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.inputs

import com.pulumi.alicloud.cloudsso.inputs.GetServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getService.
 * @property enable Setting the value to `On` to enable the service. Valid values: `On` or `Off`.
 * > **NOTE:** Setting `enable = "On"` to open the Cloud Sso service that means you have read and agreed the [Cloud Sso Terms of Service](https://help.aliyun.com/document_detail/299998.html). When there is no directory in Cloud SSO, you can set `enable = "Off"` to turn off Cloud SSO as needed. After it is closed, you can also open it at any time.
 */
public data class GetServicePlainArgs(
    public val enable: String,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.inputs.GetServicePlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.inputs.GetServicePlainArgs =
        com.pulumi.alicloud.cloudsso.inputs.GetServicePlainArgs.builder()
            .enable(enable.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServicePlainArgs].
 */
@PulumiTagMarker
public class GetServicePlainArgsBuilder internal constructor() {
    private var enable: String? = null

    /**
     * @param value Setting the value to `On` to enable the service. Valid values: `On` or `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the Cloud Sso service that means you have read and agreed the [Cloud Sso Terms of Service](https://help.aliyun.com/document_detail/299998.html). When there is no directory in Cloud SSO, you can set `enable = "Off"` to turn off Cloud SSO as needed. After it is closed, you can also open it at any time.
     */
    @JvmName("apyxnxfmxysbhano")
    public suspend fun enable(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.enable = mapped
    }

    internal fun build(): GetServicePlainArgs = GetServicePlainArgs(
        enable = enable ?: throw PulumiNullFieldException("enable"),
    )
}
