@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.inputs

import com.pulumi.alicloud.cloudsso.inputs.GetUsersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUsers.
 * @property directoryId The ID of the Directory.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of User IDs.
 * @property nameRegex A regex string to filter results by User name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property provisionType ProvisionType. Valid values: `Manual`, `Synchronized`.
 * @property status The status of user. Valid values: `Disabled`, `Enabled`.
 */
public data class GetUsersPlainArgs(
    public val directoryId: String,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val provisionType: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudsso.inputs.GetUsersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudsso.inputs.GetUsersPlainArgs =
        com.pulumi.alicloud.cloudsso.inputs.GetUsersPlainArgs.builder()
            .directoryId(directoryId.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .provisionType(provisionType?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUsersPlainArgs].
 */
@PulumiTagMarker
public class GetUsersPlainArgsBuilder internal constructor() {
    private var directoryId: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var provisionType: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the Directory.
     */
    @JvmName("sxvbeqokqmnvtawu")
    public suspend fun directoryId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.directoryId = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("bunldlesauthmqex")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of User IDs.
     */
    @JvmName("nqyefcvorvllbihy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of User IDs.
     */
    @JvmName("tlhbjivktvhtakcf")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by User name.
     */
    @JvmName("fykgvvlixasthygy")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("alehgsyvpcdaegll")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value ProvisionType. Valid values: `Manual`, `Synchronized`.
     */
    @JvmName("ppkuglaqcwwpwwxb")
    public suspend fun provisionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.provisionType = mapped
    }

    /**
     * @param value The status of user. Valid values: `Disabled`, `Enabled`.
     */
    @JvmName("qoeklkdofxtkfmjk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetUsersPlainArgs = GetUsersPlainArgs(
        directoryId = directoryId ?: throw PulumiNullFieldException("directoryId"),
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        provisionType = provisionType,
        status = status,
    )
}
