@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property permissionPolicyDocument The Content of Policy.
 * @property permissionPolicyName The Policy Name of policy. The name of the resource.
 * @property permissionPolicyType The Policy Type of policy. Valid values: `System`, `Inline`.
 */
public data class AccessConfigurationPermissionPolicy(
    public val permissionPolicyDocument: String? = null,
    public val permissionPolicyName: String,
    public val permissionPolicyType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudsso.outputs.AccessConfigurationPermissionPolicy): AccessConfigurationPermissionPolicy = AccessConfigurationPermissionPolicy(
            permissionPolicyDocument = javaType.permissionPolicyDocument().map({ args0 -> args0 }).orElse(null),
            permissionPolicyName = javaType.permissionPolicyName(),
            permissionPolicyType = javaType.permissionPolicyType(),
        )
    }
}
