@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property encodedMetadataDocument Base64 encoded IdP metadata document. **NOTE:** If the IdP Metadata has been uploaded, no update will be made if this parameter is not specified, otherwise the update will be made according to the parameter content. If IdP Metadata has not been uploaded, and the parameter `sso_status` is `Enabled`, this parameter must be provided. If the IdP Metadata has not been uploaded, and the parameter `sso_status` is `Disabled`, this parameter can be omitted, and the IdP Metadata will remain empty.
 * @property ssoStatus SAML SSO login enabled status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
 */
public data class DirectorySamlIdentityProviderConfiguration(
    public val encodedMetadataDocument: String? = null,
    public val ssoStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudsso.outputs.DirectorySamlIdentityProviderConfiguration): DirectorySamlIdentityProviderConfiguration = DirectorySamlIdentityProviderConfiguration(
            encodedMetadataDocument = javaType.encodedMetadataDocument().map({ args0 -> args0 }).orElse(null),
            ssoStatus = javaType.ssoStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
