@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessConfigurationId Access configuration ID.
 * @property accessConfigurationName The name of the access configuration.
 * @property directoryId Directory ID.
 * @property id The ID of the Access Assignment.
 * @property principalId The ID of the access assignment.
 * @property principalName Cloud SSO identity name.
 * @property principalType Create the identity type of the access assignment, which can be a user or a user group.
 * @property targetId The ID of the target to create the resource range.
 * @property targetName Task target name.
 * @property targetPathName The path name of the task target in the resource directory.
 * @property targetType The type of the resource range target to be accessed. Only a single RD primary account or member account can be specified in the first phase.
 */
public data class GetAccessAssignmentsAssignment(
    public val accessConfigurationId: String,
    public val accessConfigurationName: String,
    public val directoryId: String,
    public val id: String,
    public val principalId: String,
    public val principalName: String,
    public val principalType: String,
    public val targetId: String,
    public val targetName: String,
    public val targetPathName: String,
    public val targetType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudsso.outputs.GetAccessAssignmentsAssignment): GetAccessAssignmentsAssignment = GetAccessAssignmentsAssignment(
            accessConfigurationId = javaType.accessConfigurationId(),
            accessConfigurationName = javaType.accessConfigurationName(),
            directoryId = javaType.directoryId(),
            id = javaType.id(),
            principalId = javaType.principalId(),
            principalName = javaType.principalName(),
            principalType = javaType.principalType(),
            targetId = javaType.targetId(),
            targetName = javaType.targetName(),
            targetPathName = javaType.targetPathName(),
            targetType = javaType.targetType(),
        )
    }
}
