@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAccessAssignments.
 * @property accessConfigurationId
 * @property assignments
 * @property directoryId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property principalType
 * @property targetId
 * @property targetType
 */
public data class GetAccessAssignmentsResult(
    public val accessConfigurationId: String? = null,
    public val assignments: List<GetAccessAssignmentsAssignment>,
    public val directoryId: String,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val principalType: String? = null,
    public val targetId: String? = null,
    public val targetType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudsso.outputs.GetAccessAssignmentsResult): GetAccessAssignmentsResult = GetAccessAssignmentsResult(
            accessConfigurationId = javaType.accessConfigurationId().map({ args0 -> args0 }).orElse(null),
            assignments = javaType.assignments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudsso.kotlin.outputs.GetAccessAssignmentsAssignment.Companion.toKotlin(args0)
                })
            }),
            directoryId = javaType.directoryId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            principalType = javaType.principalType().map({ args0 -> args0 }).orElse(null),
            targetId = javaType.targetId().map({ args0 -> args0 }).orElse(null),
            targetType = javaType.targetType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
