@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accessConfigurationId The AccessConfigurationId of the Access Configuration.
 * @property accessConfigurationName The AccessConfigurationName of the Access Configuration.
 * @property createTime The Created Time of the Directory.
 * @property description The Description of the Directory.
 * @property directoryId The ID of the Directory.
 * @property id The ID of the Access Configuration.
 * @property permissionPolicies The Policy List.
 * @property relayState The RelayState of the Access Configuration.
 * @property sessionDuration The SessionDuration of the Access Configuration.
 * @property statusNotifications The StatusNotifications of the Access Configuration.
 */
public data class GetAccessConfigurationsConfiguration(
    public val accessConfigurationId: String,
    public val accessConfigurationName: String,
    public val createTime: String,
    public val description: String,
    public val directoryId: String,
    public val id: String,
    public val permissionPolicies: List<GetAccessConfigurationsConfigurationPermissionPolicy>,
    public val relayState: String,
    public val sessionDuration: Int,
    public val statusNotifications: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudsso.outputs.GetAccessConfigurationsConfiguration): GetAccessConfigurationsConfiguration = GetAccessConfigurationsConfiguration(
            accessConfigurationId = javaType.accessConfigurationId(),
            accessConfigurationName = javaType.accessConfigurationName(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            directoryId = javaType.directoryId(),
            id = javaType.id(),
            permissionPolicies = javaType.permissionPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudsso.kotlin.outputs.GetAccessConfigurationsConfigurationPermissionPolicy.Companion.toKotlin(args0)
                })
            }),
            relayState = javaType.relayState(),
            sessionDuration = javaType.sessionDuration(),
            statusNotifications = javaType.statusNotifications().map({ args0 -> args0 }),
        )
    }
}
