@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createTime The CreateTime of the CloudSSO directory.
 * @property directoryId The DirectoryId of the CloudSSO directory.
 * @property directoryName The name of the CloudSSO directory.
 * @property id The ID of the Directory.
 * @property mfaAuthenticationStatus The mfa authentication status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
 * @property region The Region of the CloudSSO directory.
 * @property samlIdentityProviderConfigurations The saml identity provider configuration.
 * @property scimSynchronizationStatus The scim synchronization status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
 * @property tasks Asynchronous Task Information Array.
 */
public data class GetDirectoriesDirectory(
    public val createTime: String,
    public val directoryId: String,
    public val directoryName: String,
    public val id: String,
    public val mfaAuthenticationStatus: String,
    public val region: String,
    public val samlIdentityProviderConfigurations: List<GetDirectoriesDirectorySamlIdentityProviderConfiguration>,
    public val scimSynchronizationStatus: String,
    public val tasks: List<GetDirectoriesDirectoryTask>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudsso.outputs.GetDirectoriesDirectory): GetDirectoriesDirectory = GetDirectoriesDirectory(
            createTime = javaType.createTime(),
            directoryId = javaType.directoryId(),
            directoryName = javaType.directoryName(),
            id = javaType.id(),
            mfaAuthenticationStatus = javaType.mfaAuthenticationStatus(),
            region = javaType.region(),
            samlIdentityProviderConfigurations = javaType.samlIdentityProviderConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudsso.kotlin.outputs.GetDirectoriesDirectorySamlIdentityProviderConfiguration.Companion.toKotlin(args0)
                })
            }),
            scimSynchronizationStatus = javaType.scimSynchronizationStatus(),
            tasks = javaType.tasks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudsso.kotlin.outputs.GetDirectoriesDirectoryTask.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
