@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime Saml identifies the creation time of the provider configuration.
 * @property encodedMetadataDocument Base64 encoded IdP metadata document.
 * @property entityId SAML IdPEntityID.
 * @property loginUrl SAML IdP http-post Binding address.
 * @property ssoStatus SAML SSO login enabled status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
 */
public data class GetDirectoriesDirectorySamlIdentityProviderConfiguration(
    public val createTime: String,
    public val encodedMetadataDocument: String,
    public val entityId: String,
    public val loginUrl: String,
    public val ssoStatus: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudsso.outputs.GetDirectoriesDirectorySamlIdentityProviderConfiguration): GetDirectoriesDirectorySamlIdentityProviderConfiguration =
            GetDirectoriesDirectorySamlIdentityProviderConfiguration(
                createTime = javaType.createTime(),
                encodedMetadataDocument = javaType.encodedMetadataDocument(),
                entityId = javaType.entityId(),
                loginUrl = javaType.loginUrl(),
                ssoStatus = javaType.ssoStatus(),
            )
    }
}
