@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessConfigurationId The ID of Access Configuration.
 * @property accessConfigurationName The Name of Access Configuration.
 * @property endTime The End Time of Task.
 * @property failureReason the Reason for the Failure of  the task.
 * @property principalId The ID of Cloud SSO Identity.
 * @property principalName The Name of Cloud SSO Identity.
 * @property principalType The Type of Cloud SSO Identity.
 * @property startTime The Start Time of Task.
 * @property status The Task Status.
 * @property targetId The Id of deploy target.
 * @property targetName The Name of Deploy Target.
 * @property targetPath The Path in RD of Deploy Target.
 * @property targetType The Type of Deploy Target.
 * @property taskId The ID of the Task.
 * @property taskType The Type of the Task.
 */
public data class GetDirectoriesDirectoryTask(
    public val accessConfigurationId: String,
    public val accessConfigurationName: String,
    public val endTime: String,
    public val failureReason: String,
    public val principalId: String,
    public val principalName: String,
    public val principalType: String,
    public val startTime: String,
    public val status: String,
    public val targetId: String,
    public val targetName: String,
    public val targetPath: String,
    public val targetType: String,
    public val taskId: String,
    public val taskType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudsso.outputs.GetDirectoriesDirectoryTask): GetDirectoriesDirectoryTask = GetDirectoriesDirectoryTask(
            accessConfigurationId = javaType.accessConfigurationId(),
            accessConfigurationName = javaType.accessConfigurationName(),
            endTime = javaType.endTime(),
            failureReason = javaType.failureReason(),
            principalId = javaType.principalId(),
            principalName = javaType.principalName(),
            principalType = javaType.principalType(),
            startTime = javaType.startTime(),
            status = javaType.status(),
            targetId = javaType.targetId(),
            targetName = javaType.targetName(),
            targetPath = javaType.targetPath(),
            targetType = javaType.targetType(),
            taskId = javaType.taskId(),
            taskType = javaType.taskType(),
        )
    }
}
