@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The Created Time of the Directory.
 * @property description The Description of the Directory.
 * @property directoryId The ID of the Directory.
 * @property groupId The Group ID of the group.
 * @property groupName The Name of the group.
 * @property id The ID of the Group.
 * @property provisionType The Provision Type of the Group. Valid values: `Manual`, `Synchronized`.
 */
public data class GetGroupsGroup(
    public val createTime: String,
    public val description: String,
    public val directoryId: String,
    public val groupId: String,
    public val groupName: String,
    public val id: String,
    public val provisionType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudsso.outputs.GetGroupsGroup): GetGroupsGroup = GetGroupsGroup(
            createTime = javaType.createTime(),
            description = javaType.description(),
            directoryId = javaType.directoryId(),
            groupId = javaType.groupId(),
            groupName = javaType.groupName(),
            id = javaType.id(),
            provisionType = javaType.provisionType(),
        )
    }
}
