@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The CreateTime of the resource.
 * @property credentialId The CredentialId of the resource.
 * @property credentialSecret The CredentialSecret of the resource.
 * @property credentialType The CredentialType of the resource.
 * @property directoryId The ID of the Directory.
 * @property expireTime The ExpireTime of the resource.
 * @property id The ID of the SCIM Server Credential.
 * @property status The Status of the resource. Valid values: `Disabled`, `Enabled`.
 */
public data class GetScimServerCredentialsCredential(
    public val createTime: String,
    public val credentialId: String,
    public val credentialSecret: String,
    public val credentialType: String,
    public val directoryId: String,
    public val expireTime: String,
    public val id: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudsso.outputs.GetScimServerCredentialsCredential): GetScimServerCredentialsCredential = GetScimServerCredentialsCredential(
            createTime = javaType.createTime(),
            credentialId = javaType.credentialId(),
            credentialSecret = javaType.credentialSecret(),
            credentialType = javaType.credentialType(),
            directoryId = javaType.directoryId(),
            expireTime = javaType.expireTime(),
            id = javaType.id(),
            status = javaType.status(),
        )
    }
}
