@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getScimServerCredentials.
 * @property credentials
 * @property directoryId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property status
 */
public data class GetScimServerCredentialsResult(
    public val credentials: List<GetScimServerCredentialsCredential>,
    public val directoryId: String,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudsso.outputs.GetScimServerCredentialsResult): GetScimServerCredentialsResult = GetScimServerCredentialsResult(
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudsso.kotlin.outputs.GetScimServerCredentialsCredential.Companion.toKotlin(args0)
                })
            }),
            directoryId = javaType.directoryId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
