@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getService.
 * @property enable
 * @property id The provider-assigned unique ID for this managed resource.
 * @property status The current service enable status.
 */
public data class GetServiceResult(
    public val enable: String,
    public val id: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudsso.outputs.GetServiceResult): GetServiceResult = GetServiceResult(
            enable = javaType.enable(),
            id = javaType.id(),
            status = javaType.status(),
        )
    }
}
