@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudsso.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createTime The create time of the user.
 * @property description The description of user.
 * @property directoryId The ID of the Directory.
 * @property displayName The display name of user.
 * @property email The User's Contact Email Address.
 * @property firstName The first name of user.
 * @property id The ID of the User.
 * @property lastName The last name of user.
 * @property mfaDevices The List of MFA Device for User.
 * @property provisionType ProvisionType.
 * @property status User status. Valid values: `Enabled` and `Disabled`.
 * @property userId The User ID of the group.
 * @property userName The name of user.
 */
public data class GetUsersUser(
    public val createTime: String,
    public val description: String,
    public val directoryId: String,
    public val displayName: String,
    public val email: String,
    public val firstName: String,
    public val id: String,
    public val lastName: String,
    public val mfaDevices: List<GetUsersUserMfaDevice>,
    public val provisionType: String,
    public val status: String,
    public val userId: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudsso.outputs.GetUsersUser): GetUsersUser =
            GetUsersUser(
                createTime = javaType.createTime(),
                description = javaType.description(),
                directoryId = javaType.directoryId(),
                displayName = javaType.displayName(),
                email = javaType.email(),
                firstName = javaType.firstName(),
                id = javaType.id(),
                lastName = javaType.lastName(),
                mfaDevices = javaType.mfaDevices().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.cloudsso.kotlin.outputs.GetUsersUserMfaDevice.Companion.toKotlin(args0)
                    })
                }),
                provisionType = javaType.provisionType(),
                status = javaType.status(),
                userId = javaType.userId(),
                userName = javaType.userName(),
            )
    }
}
