@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions.getExpressSyncsPlain
import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions.getGatewayBlockVolumesPlain
import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions.getGatewayCacheDisksPlain
import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions.getGatewayFileSharesPlain
import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions.getGatewaySmbUsersPlain
import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions.getGatewaysPlain
import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions.getServicePlain
import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions.getStocksPlain
import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions.getStorageBundlesPlain
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetExpressSyncsPlainArgs
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetExpressSyncsPlainArgsBuilder
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetGatewayBlockVolumesPlainArgs
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetGatewayBlockVolumesPlainArgsBuilder
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetGatewayCacheDisksPlainArgs
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetGatewayCacheDisksPlainArgsBuilder
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetGatewayFileSharesPlainArgs
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetGatewayFileSharesPlainArgsBuilder
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetGatewaySmbUsersPlainArgs
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetGatewaySmbUsersPlainArgsBuilder
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetGatewaysPlainArgs
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetGatewaysPlainArgsBuilder
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetStocksPlainArgs
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetStocksPlainArgsBuilder
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetStorageBundlesPlainArgs
import com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs.GetStorageBundlesPlainArgsBuilder
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetExpressSyncsResult
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetGatewayBlockVolumesResult
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetGatewayCacheDisksResult
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetGatewayFileSharesResult
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetGatewaySmbUsersResult
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetGatewaysResult
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetStocksResult
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetStorageBundlesResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetExpressSyncsResult.Companion.toKotlin as getExpressSyncsResultToKotlin
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetGatewayBlockVolumesResult.Companion.toKotlin as getGatewayBlockVolumesResultToKotlin
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetGatewayCacheDisksResult.Companion.toKotlin as getGatewayCacheDisksResultToKotlin
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetGatewayFileSharesResult.Companion.toKotlin as getGatewayFileSharesResultToKotlin
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetGatewaySmbUsersResult.Companion.toKotlin as getGatewaySmbUsersResultToKotlin
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetGatewaysResult.Companion.toKotlin as getGatewaysResultToKotlin
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetStocksResult.Companion.toKotlin as getStocksResultToKotlin
import com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetStorageBundlesResult.Companion.toKotlin as getStorageBundlesResultToKotlin

public object CloudstoragegatewayFunctions {
    /**
     * This data source provides the Cloud Storage Gateway Express Syncs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.144.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cloudstoragegateway.getExpressSyncs({});
     * export const cloudStorageGatewayExpressSyncId1 = ids.then(ids => ids.syncs?.[0]?.id);
     * const nameRegex = alicloud.cloudstoragegateway.getExpressSyncs({
     *     nameRegex: "^my-ExpressSync",
     * });
     * export const cloudStorageGatewayExpressSyncId2 = nameRegex.then(nameRegex => nameRegex.syncs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cloudstoragegateway.get_express_syncs()
     * pulumi.export("cloudStorageGatewayExpressSyncId1", ids.syncs[0].id)
     * name_regex = alicloud.cloudstoragegateway.get_express_syncs(name_regex="^my-ExpressSync")
     * pulumi.export("cloudStorageGatewayExpressSyncId2", name_regex.syncs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CloudStorageGateway.GetExpressSyncs.Invoke();
     *     var nameRegex = AliCloud.CloudStorageGateway.GetExpressSyncs.Invoke(new()
     *     {
     *         NameRegex = "^my-ExpressSync",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudStorageGatewayExpressSyncId1"] = ids&#46;Apply(getExpressSyncsResult => getExpressSyncsResult&#46;Syncs[0]?.Id),
     *         ["cloudStorageGatewayExpressSyncId2"] = nameRegex&#46;Apply(getExpressSyncsResult => getExpressSyncsResult&#46;Syncs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudstoragegateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cloudstoragegateway.GetExpressSyncs(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudStorageGatewayExpressSyncId1", ids.Syncs[0].Id)
     * 		nameRegex, err := cloudstoragegateway.GetExpressSyncs(ctx, &cloudstoragegateway.GetExpressSyncsArgs{
     * 			NameRegex: pulumi.StringRef("^my-ExpressSync"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudStorageGatewayExpressSyncId2", nameRegex.Syncs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions;
     * import com.pulumi.alicloud.cloudstoragegateway.inputs.GetExpressSyncsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CloudstoragegatewayFunctions.getExpressSyncs();
     *         ctx.export("cloudStorageGatewayExpressSyncId1", ids.applyValue(getExpressSyncsResult -> getExpressSyncsResult.syncs()[0].id()));
     *         final var nameRegex = CloudstoragegatewayFunctions.getExpressSyncs(GetExpressSyncsArgs.builder()
     *             .nameRegex("^my-ExpressSync")
     *             .build());
     *         ctx.export("cloudStorageGatewayExpressSyncId2", nameRegex.applyValue(getExpressSyncsResult -> getExpressSyncsResult.syncs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudstoragegateway:getExpressSyncs
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cloudstoragegateway:getExpressSyncs
     *       Arguments:
     *         nameRegex: ^my-ExpressSync
     * outputs:
     *   cloudStorageGatewayExpressSyncId1: ${ids.syncs[0].id}
     *   cloudStorageGatewayExpressSyncId2: ${nameRegex.syncs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getExpressSyncs.
     * @return A collection of values returned by getExpressSyncs.
     */
    public suspend fun getExpressSyncs(argument: GetExpressSyncsPlainArgs): GetExpressSyncsResult =
        getExpressSyncsResultToKotlin(getExpressSyncsPlain(argument.toJava()).await())

    /**
     * @see [getExpressSyncs].
     * @param ids A list of Express Sync IDs.
     * @param nameRegex A regex string to filter results by Express Sync name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getExpressSyncs.
     */
    public suspend fun getExpressSyncs(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetExpressSyncsResult {
        val argument = GetExpressSyncsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getExpressSyncsResultToKotlin(getExpressSyncsPlain(argument.toJava()).await())
    }

    /**
     * @see [getExpressSyncs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudstoragegateway&#46;kotlin&#46;inputs&#46;GetExpressSyncsPlainArgs].
     * @return A collection of values returned by getExpressSyncs.
     */
    public suspend fun getExpressSyncs(argument: suspend GetExpressSyncsPlainArgsBuilder.() -> Unit): GetExpressSyncsResult {
        val builder = GetExpressSyncsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExpressSyncsResultToKotlin(getExpressSyncsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cloud Storage Gateway Gateway Block Volumes of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.144.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cloudstoragegateway.getGatewayBlockVolumes({
     *     gatewayId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const cloudStorageGatewayGatewayBlockVolumeId1 = ids.then(ids => ids.volumes?.[0]?.id);
     * const nameRegex = alicloud.cloudstoragegateway.getGatewayBlockVolumes({
     *     gatewayId: "example_value",
     *     nameRegex: "^my-GatewayBlockVolume",
     * });
     * export const cloudStorageGatewayGatewayBlockVolumeId2 = nameRegex.then(nameRegex => nameRegex.volumes?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cloudstoragegateway.get_gateway_block_volumes(gateway_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("cloudStorageGatewayGatewayBlockVolumeId1", ids.volumes[0].id)
     * name_regex = alicloud.cloudstoragegateway.get_gateway_block_volumes(gateway_id="example_value",
     *     name_regex="^my-GatewayBlockVolume")
     * pulumi.export("cloudStorageGatewayGatewayBlockVolumeId2", name_regex.volumes[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CloudStorageGateway.GetGatewayBlockVolumes.Invoke(new()
     *     {
     *         GatewayId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.CloudStorageGateway.GetGatewayBlockVolumes.Invoke(new()
     *     {
     *         GatewayId = "example_value",
     *         NameRegex = "^my-GatewayBlockVolume",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudStorageGatewayGatewayBlockVolumeId1"] = ids&#46;Apply(getGatewayBlockVolumesResult => getGatewayBlockVolumesResult&#46;Volumes[0]?.Id),
     *         ["cloudStorageGatewayGatewayBlockVolumeId2"] = nameRegex&#46;Apply(getGatewayBlockVolumesResult => getGatewayBlockVolumesResult&#46;Volumes[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudstoragegateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cloudstoragegateway.GetGatewayBlockVolumes(ctx, &cloudstoragegateway.GetGatewayBlockVolumesArgs{
     * 			GatewayId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudStorageGatewayGatewayBlockVolumeId1", ids.Volumes[0].Id)
     * 		nameRegex, err := cloudstoragegateway.GetGatewayBlockVolumes(ctx, &cloudstoragegateway.GetGatewayBlockVolumesArgs{
     * 			GatewayId: "example_value",
     * 			NameRegex: pulumi.StringRef("^my-GatewayBlockVolume"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudStorageGatewayGatewayBlockVolumeId2", nameRegex.Volumes[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions;
     * import com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewayBlockVolumesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CloudstoragegatewayFunctions.getGatewayBlockVolumes(GetGatewayBlockVolumesArgs.builder()
     *             .gatewayId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("cloudStorageGatewayGatewayBlockVolumeId1", ids.applyValue(getGatewayBlockVolumesResult -> getGatewayBlockVolumesResult.volumes()[0].id()));
     *         final var nameRegex = CloudstoragegatewayFunctions.getGatewayBlockVolumes(GetGatewayBlockVolumesArgs.builder()
     *             .gatewayId("example_value")
     *             .nameRegex("^my-GatewayBlockVolume")
     *             .build());
     *         ctx.export("cloudStorageGatewayGatewayBlockVolumeId2", nameRegex.applyValue(getGatewayBlockVolumesResult -> getGatewayBlockVolumesResult.volumes()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudstoragegateway:getGatewayBlockVolumes
     *       Arguments:
     *         gatewayId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cloudstoragegateway:getGatewayBlockVolumes
     *       Arguments:
     *         gatewayId: example_value
     *         nameRegex: ^my-GatewayBlockVolume
     * outputs:
     *   cloudStorageGatewayGatewayBlockVolumeId1: ${ids.volumes[0].id}
     *   cloudStorageGatewayGatewayBlockVolumeId2: ${nameRegex.volumes[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGatewayBlockVolumes.
     * @return A collection of values returned by getGatewayBlockVolumes.
     */
    public suspend fun getGatewayBlockVolumes(argument: GetGatewayBlockVolumesPlainArgs): GetGatewayBlockVolumesResult =
        getGatewayBlockVolumesResultToKotlin(getGatewayBlockVolumesPlain(argument.toJava()).await())

    /**
     * @see [getGatewayBlockVolumes].
     * @param gatewayId The Gateway ID.
     * @param ids A list of Gateway Block Volume IDs.
     * @param nameRegex A regex string to filter results by Gateway Block Volume name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of volume. Valid values:
     * @return A collection of values returned by getGatewayBlockVolumes.
     */
    public suspend fun getGatewayBlockVolumes(
        gatewayId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: Int? = null,
    ): GetGatewayBlockVolumesResult {
        val argument = GetGatewayBlockVolumesPlainArgs(
            gatewayId = gatewayId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getGatewayBlockVolumesResultToKotlin(getGatewayBlockVolumesPlain(argument.toJava()).await())
    }

    /**
     * @see [getGatewayBlockVolumes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudstoragegateway&#46;kotlin&#46;inputs&#46;GetGatewayBlockVolumesPlainArgs].
     * @return A collection of values returned by getGatewayBlockVolumes.
     */
    public suspend fun getGatewayBlockVolumes(argument: suspend GetGatewayBlockVolumesPlainArgsBuilder.() -> Unit): GetGatewayBlockVolumesResult {
        val builder = GetGatewayBlockVolumesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayBlockVolumesResultToKotlin(getGatewayBlockVolumesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cloud Storage Gateway Gateway Cache Disks of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.144.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cloudstoragegateway.getGatewayCacheDisks({
     *     gatewayId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const cloudStorageGatewayGatewayCacheDiskId1 = ids.then(ids => ids.disks?.[0]?.id);
     * const status = alicloud.cloudstoragegateway.getGatewayCacheDisks({
     *     gatewayId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     *     status: 0,
     * });
     * export const cloudStorageGatewayGatewayCacheDiskId2 = status.then(status => status.disks?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cloudstoragegateway.get_gateway_cache_disks(gateway_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("cloudStorageGatewayGatewayCacheDiskId1", ids.disks[0].id)
     * status = alicloud.cloudstoragegateway.get_gateway_cache_disks(gateway_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     *     status=0)
     * pulumi.export("cloudStorageGatewayGatewayCacheDiskId2", status.disks[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CloudStorageGateway.GetGatewayCacheDisks.Invoke(new()
     *     {
     *         GatewayId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var status = AliCloud.CloudStorageGateway.GetGatewayCacheDisks.Invoke(new()
     *     {
     *         GatewayId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *         Status = 0,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudStorageGatewayGatewayCacheDiskId1"] = ids&#46;Apply(getGatewayCacheDisksResult => getGatewayCacheDisksResult&#46;Disks[0]?.Id),
     *         ["cloudStorageGatewayGatewayCacheDiskId2"] = status&#46;Apply(getGatewayCacheDisksResult => getGatewayCacheDisksResult&#46;Disks[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudstoragegateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cloudstoragegateway.GetGatewayCacheDisks(ctx, &cloudstoragegateway.GetGatewayCacheDisksArgs{
     * 			GatewayId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudStorageGatewayGatewayCacheDiskId1", ids.Disks[0].Id)
     * 		status, err := cloudstoragegateway.GetGatewayCacheDisks(ctx, &cloudstoragegateway.GetGatewayCacheDisksArgs{
     * 			GatewayId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 			Status: pulumi.IntRef(0),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudStorageGatewayGatewayCacheDiskId2", status.Disks[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions;
     * import com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewayCacheDisksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CloudstoragegatewayFunctions.getGatewayCacheDisks(GetGatewayCacheDisksArgs.builder()
     *             .gatewayId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("cloudStorageGatewayGatewayCacheDiskId1", ids.applyValue(getGatewayCacheDisksResult -> getGatewayCacheDisksResult.disks()[0].id()));
     *         final var status = CloudstoragegatewayFunctions.getGatewayCacheDisks(GetGatewayCacheDisksArgs.builder()
     *             .gatewayId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .status("0")
     *             .build());
     *         ctx.export("cloudStorageGatewayGatewayCacheDiskId2", status.applyValue(getGatewayCacheDisksResult -> getGatewayCacheDisksResult.disks()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudstoragegateway:getGatewayCacheDisks
     *       Arguments:
     *         gatewayId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   status:
     *     fn::invoke:
     *       Function: alicloud:cloudstoragegateway:getGatewayCacheDisks
     *       Arguments:
     *         gatewayId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *         status: '0'
     * outputs:
     *   cloudStorageGatewayGatewayCacheDiskId1: ${ids.disks[0].id}
     *   cloudStorageGatewayGatewayCacheDiskId2: ${status.disks[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGatewayCacheDisks.
     * @return A collection of values returned by getGatewayCacheDisks.
     */
    public suspend fun getGatewayCacheDisks(argument: GetGatewayCacheDisksPlainArgs): GetGatewayCacheDisksResult =
        getGatewayCacheDisksResultToKotlin(getGatewayCacheDisksPlain(argument.toJava()).await())

    /**
     * @see [getGatewayCacheDisks].
     * @param gatewayId The ID of the gateway.
     * @param ids A list of Gateway Cache Disk IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `0`, `1`, `2`. `0`: Normal. `1`: Is about to expire. `2`: Has expired.
     * @return A collection of values returned by getGatewayCacheDisks.
     */
    public suspend fun getGatewayCacheDisks(
        gatewayId: String,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: Int? = null,
    ): GetGatewayCacheDisksResult {
        val argument = GetGatewayCacheDisksPlainArgs(
            gatewayId = gatewayId,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getGatewayCacheDisksResultToKotlin(getGatewayCacheDisksPlain(argument.toJava()).await())
    }

    /**
     * @see [getGatewayCacheDisks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudstoragegateway&#46;kotlin&#46;inputs&#46;GetGatewayCacheDisksPlainArgs].
     * @return A collection of values returned by getGatewayCacheDisks.
     */
    public suspend fun getGatewayCacheDisks(argument: suspend GetGatewayCacheDisksPlainArgsBuilder.() -> Unit): GetGatewayCacheDisksResult {
        val builder = GetGatewayCacheDisksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayCacheDisksResultToKotlin(getGatewayCacheDisksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cloud Storage Gateway Gateway File Shares of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.144.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cloudstoragegateway.getGatewayFileShares({
     *     gatewayId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const cloudStorageGatewayGatewayFileShareId1 = ids.then(ids => ids.shares?.[0]?.id);
     * const nameRegex = alicloud.cloudstoragegateway.getGatewayFileShares({
     *     gatewayId: "example_value",
     *     nameRegex: "^my-GatewayFileShare",
     * });
     * export const cloudStorageGatewayGatewayFileShareId2 = nameRegex.then(nameRegex => nameRegex.shares?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cloudstoragegateway.get_gateway_file_shares(gateway_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("cloudStorageGatewayGatewayFileShareId1", ids.shares[0].id)
     * name_regex = alicloud.cloudstoragegateway.get_gateway_file_shares(gateway_id="example_value",
     *     name_regex="^my-GatewayFileShare")
     * pulumi.export("cloudStorageGatewayGatewayFileShareId2", name_regex.shares[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CloudStorageGateway.GetGatewayFileShares.Invoke(new()
     *     {
     *         GatewayId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.CloudStorageGateway.GetGatewayFileShares.Invoke(new()
     *     {
     *         GatewayId = "example_value",
     *         NameRegex = "^my-GatewayFileShare",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudStorageGatewayGatewayFileShareId1"] = ids&#46;Apply(getGatewayFileSharesResult => getGatewayFileSharesResult&#46;Shares[0]?.Id),
     *         ["cloudStorageGatewayGatewayFileShareId2"] = nameRegex&#46;Apply(getGatewayFileSharesResult => getGatewayFileSharesResult&#46;Shares[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudstoragegateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cloudstoragegateway.GetGatewayFileShares(ctx, &cloudstoragegateway.GetGatewayFileSharesArgs{
     * 			GatewayId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudStorageGatewayGatewayFileShareId1", ids.Shares[0].Id)
     * 		nameRegex, err := cloudstoragegateway.GetGatewayFileShares(ctx, &cloudstoragegateway.GetGatewayFileSharesArgs{
     * 			GatewayId: "example_value",
     * 			NameRegex: pulumi.StringRef("^my-GatewayFileShare"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cloudStorageGatewayGatewayFileShareId2", nameRegex.Shares[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions;
     * import com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewayFileSharesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CloudstoragegatewayFunctions.getGatewayFileShares(GetGatewayFileSharesArgs.builder()
     *             .gatewayId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("cloudStorageGatewayGatewayFileShareId1", ids.applyValue(getGatewayFileSharesResult -> getGatewayFileSharesResult.shares()[0].id()));
     *         final var nameRegex = CloudstoragegatewayFunctions.getGatewayFileShares(GetGatewayFileSharesArgs.builder()
     *             .gatewayId("example_value")
     *             .nameRegex("^my-GatewayFileShare")
     *             .build());
     *         ctx.export("cloudStorageGatewayGatewayFileShareId2", nameRegex.applyValue(getGatewayFileSharesResult -> getGatewayFileSharesResult.shares()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudstoragegateway:getGatewayFileShares
     *       Arguments:
     *         gatewayId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cloudstoragegateway:getGatewayFileShares
     *       Arguments:
     *         gatewayId: example_value
     *         nameRegex: ^my-GatewayFileShare
     * outputs:
     *   cloudStorageGatewayGatewayFileShareId1: ${ids.shares[0].id}
     *   cloudStorageGatewayGatewayFileShareId2: ${nameRegex.shares[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGatewayFileShares.
     * @return A collection of values returned by getGatewayFileShares.
     */
    public suspend fun getGatewayFileShares(argument: GetGatewayFileSharesPlainArgs): GetGatewayFileSharesResult =
        getGatewayFileSharesResultToKotlin(getGatewayFileSharesPlain(argument.toJava()).await())

    /**
     * @see [getGatewayFileShares].
     * @param gatewayId The ID of the gateway.
     * @param ids A list of Gateway File Share IDs.
     * @param nameRegex A regex string to filter results by Gateway File Share name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getGatewayFileShares.
     */
    public suspend fun getGatewayFileShares(
        gatewayId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetGatewayFileSharesResult {
        val argument = GetGatewayFileSharesPlainArgs(
            gatewayId = gatewayId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getGatewayFileSharesResultToKotlin(getGatewayFileSharesPlain(argument.toJava()).await())
    }

    /**
     * @see [getGatewayFileShares].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudstoragegateway&#46;kotlin&#46;inputs&#46;GetGatewayFileSharesPlainArgs].
     * @return A collection of values returned by getGatewayFileShares.
     */
    public suspend fun getGatewayFileShares(argument: suspend GetGatewayFileSharesPlainArgsBuilder.() -> Unit): GetGatewayFileSharesResult {
        val builder = GetGatewayFileSharesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayFileSharesResultToKotlin(getGatewayFileSharesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cloud Storage Gateway Gateway SMB Users of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.142.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.vpc.getNetworks({
     *     nameRegex: "default-NODELETING",
     * });
     * const defaultGetSwitches = _default.then(_default => alicloud.vpc.getSwitches({
     *     vpcId: _default.ids?.[0],
     * }));
     * const example = new alicloud.cloudstoragegateway.StorageBundle("example", {storageBundleName: "example_value"});
     * const defaultGateway = new alicloud.cloudstoragegateway.Gateway("default", {
     *     description: "tf-acctestDesalone",
     *     gatewayClass: "Standard",
     *     type: "File",
     *     paymentType: "PayAsYouGo",
     *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
     *     releaseAfterExpiration: false,
     *     publicNetworkBandwidth: 40,
     *     storageBundleId: example.id,
     *     location: "Cloud",
     *     gatewayName: "example_value",
     * });
     * const defaultGatewaySmbUser = new alicloud.cloudstoragegateway.GatewaySmbUser("default", {
     *     username: "your_username",
     *     password: "password",
     *     gatewayId: defaultGateway.id,
     * });
     * const ids = alicloud.cloudstoragegateway.getGatewaySmbUsersOutput({
     *     gatewayId: defaultGateway.id,
     *     ids: [defaultGatewaySmbUser&#46;id],
     * });
     * export const cloudStorageGatewayGatewaySmbUserId1 = ids.apply(ids => ids.users?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.vpc.get_networks(name_regex="default-NODELETING")
     * default_get_switches = alicloud.vpc.get_switches(vpc_id=default.ids[0])
     * example = alicloud.cloudstoragegateway.StorageBundle("example", storage_bundle_name="example_value")
     * default_gateway = alicloud.cloudstoragegateway.Gateway("default",
     *     description="tf-acctestDesalone",
     *     gateway_class="Standard",
     *     type="File",
     *     payment_type="PayAsYouGo",
     *     vswitch_id=default_get_switches.ids[0],
     *     release_after_expiration=False,
     *     public_network_bandwidth=40,
     *     storage_bundle_id=example.id,
     *     location="Cloud",
     *     gateway_name="example_value")
     * default_gateway_smb_user = alicloud.cloudstoragegateway.GatewaySmbUser("default",
     *     username="your_username",
     *     password="password",
     *     gateway_id=default_gateway.id)
     * ids = alicloud.cloudstoragegateway.get_gateway_smb_users_output(gateway_id=default_gateway.id,
     *     ids=[default_gateway_smb_user&#46;id])
     * pulumi.export("cloudStorageGatewayGatewaySmbUserId1", ids.users[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Vpc.GetNetworks.Invoke(new()
     *     {
     *         NameRegex = "default-NODELETING",
     *     });
     *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
     *     {
     *         VpcId = @default.Apply(getNetworksResult => getNetworksResult.Ids[0]),
     *     });
     *     var example = new AliCloud.CloudStorageGateway.StorageBundle("example", new()
     *     {
     *         StorageBundleName = "example_value",
     *     });
     *     var defaultGateway = new AliCloud.CloudStorageGateway.Gateway("default", new()
     *     {
     *         Description = "tf-acctestDesalone",
     *         GatewayClass = "Standard",
     *         Type = "File",
     *         PaymentType = "PayAsYouGo",
     *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
     *         ReleaseAfterExpiration = false,
     *         PublicNetworkBandwidth = 40,
     *         StorageBundleId = example.Id,
     *         Location = "Cloud",
     *         GatewayName = "example_value",
     *     });
     *     var defaultGatewaySmbUser = new AliCloud.CloudStorageGateway.GatewaySmbUser("default", new()
     *     {
     *         Username = "your_username",
     *         Password = "password",
     *         GatewayId = defaultGateway.Id,
     *     });
     *     var ids = AliCloud.CloudStorageGateway.GetGatewaySmbUsers.Invoke(new()
     *     {
     *         GatewayId = defaultGateway.Id,
     *         Ids = new[]
     *         {
     *             defaultGatewaySmbUser.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudStorageGatewayGatewaySmbUserId1"] = ids&#46;Apply(getGatewaySmbUsersResult => getGatewaySmbUsersResult&#46;Users[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudstoragegateway"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
     * 			NameRegex: pulumi.StringRef("default-NODELETING"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
     * 			VpcId: pulumi.StringRef(_default.Ids[0]),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		example, err := cloudstoragegateway.NewStorageBundle(ctx, "example", &cloudstoragegateway.StorageBundleArgs{
     * 			StorageBundleName: pulumi.String("example_value"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGateway, err := cloudstoragegateway.NewGateway(ctx, "default", &cloudstoragegateway.GatewayArgs{
     * 			Description:            pulumi.String("tf-acctestDesalone"),
     * 			GatewayClass:           pulumi.String("Standard"),
     * 			Type:                   pulumi.String("File"),
     * 			PaymentType:            pulumi.String("PayAsYouGo"),
     * 			VswitchId:              pulumi.String(defaultGetSwitches.Ids[0]),
     * 			ReleaseAfterExpiration: pulumi.Bool(false),
     * 			PublicNetworkBandwidth: pulumi.Int(40),
     * 			StorageBundleId:        example.ID(),
     * 			Location:               pulumi.String("Cloud"),
     * 			GatewayName:            pulumi.String("example_value"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGatewaySmbUser, err := cloudstoragegateway.NewGatewaySmbUser(ctx, "default", &cloudstoragegateway.GatewaySmbUserArgs{
     * 			Username:  pulumi.String("your_username"),
     * 			Password:  pulumi.String("password"),
     * 			GatewayId: defaultGateway.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids := cloudstoragegateway.GetGatewaySmbUsersOutput(ctx, cloudstoragegateway.GetGatewaySmbUsersOutputArgs{
     * 			GatewayId: defaultGateway.ID(),
     * 			Ids: pulumi.StringArray{
     * 				defaultGatewaySmbUser.ID(),
     * 			},
     * 		}, nil)
     * 		ctx.Export("cloudStorageGatewayGatewaySmbUserId1", ids.ApplyT(func(ids cloudstoragegateway.GetGatewaySmbUsersResult) (*string, error) {
     * 			return &ids.Users[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
     * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
     * import com.pulumi.alicloud.cloudstoragegateway.StorageBundle;
     * import com.pulumi.alicloud.cloudstoragegateway.StorageBundleArgs;
     * import com.pulumi.alicloud.cloudstoragegateway.Gateway;
     * import com.pulumi.alicloud.cloudstoragegateway.GatewayArgs;
     * import com.pulumi.alicloud.cloudstoragegateway.GatewaySmbUser;
     * import com.pulumi.alicloud.cloudstoragegateway.GatewaySmbUserArgs;
     * import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions;
     * import com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewaySmbUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = VpcFunctions.getNetworks(GetNetworksArgs.builder()
     *             .nameRegex("default-NODELETING")
     *             .build());
     *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
     *             .vpcId(default_.ids()[0])
     *             .build());
     *         var example = new StorageBundle("example", StorageBundleArgs.builder()
     *             .storageBundleName("example_value")
     *             .build());
     *         var defaultGateway = new Gateway("defaultGateway", GatewayArgs.builder()
     *             .description("tf-acctestDesalone")
     *             .gatewayClass("Standard")
     *             .type("File")
     *             .paymentType("PayAsYouGo")
     *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
     *             .releaseAfterExpiration(false)
     *             .publicNetworkBandwidth(40)
     *             .storageBundleId(example.id())
     *             .location("Cloud")
     *             .gatewayName("example_value")
     *             .build());
     *         var defaultGatewaySmbUser = new GatewaySmbUser("defaultGatewaySmbUser", GatewaySmbUserArgs.builder()
     *             .username("your_username")
     *             .password("password")
     *             .gatewayId(defaultGateway.id())
     *             .build());
     *         final var ids = CloudstoragegatewayFunctions.getGatewaySmbUsers(GetGatewaySmbUsersArgs.builder()
     *             .gatewayId(defaultGateway.id())
     *             .ids(defaultGatewaySmbUser.id())
     *             .build());
     *         ctx.export("cloudStorageGatewayGatewaySmbUserId1", ids.applyValue(getGatewaySmbUsersResult -> getGatewaySmbUsersResult).applyValue(ids -> ids.applyValue(getGatewaySmbUsersResult -> getGatewaySmbUsersResult.users()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   example:
     *     type: alicloud:cloudstoragegateway:StorageBundle
     *     properties:
     *       storageBundleName: example_value
     *   defaultGateway:
     *     type: alicloud:cloudstoragegateway:Gateway
     *     name: default
     *     properties:
     *       description: tf-acctestDesalone
     *       gatewayClass: Standard
     *       type: File
     *       paymentType: PayAsYouGo
     *       vswitchId: ${defaultGetSwitches.ids[0]}
     *       releaseAfterExpiration: false
     *       publicNetworkBandwidth: 40
     *       storageBundleId: ${example.id}
     *       location: Cloud
     *       gatewayName: example_value
     *   defaultGatewaySmbUser:
     *     type: alicloud:cloudstoragegateway:GatewaySmbUser
     *     name: default
     *     properties:
     *       username: your_username
     *       password: password
     *       gatewayId: ${defaultGateway.id}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNetworks
     *       Arguments:
     *         nameRegex: default-NODELETING
     *   defaultGetSwitches:
     *     fn::invoke:
     *       Function: alicloud:vpc:getSwitches
     *       Arguments:
     *         vpcId: ${default.ids[0]}
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cloudstoragegateway:getGatewaySmbUsers
     *       Arguments:
     *         gatewayId: ${defaultGateway.id}
     *         ids:
     *           - ${defaultGatewaySmbUser.id}
     * outputs:
     *   cloudStorageGatewayGatewaySmbUserId1: ${ids.users[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGatewaySmbUsers.
     * @return A collection of values returned by getGatewaySmbUsers.
     */
    public suspend fun getGatewaySmbUsers(argument: GetGatewaySmbUsersPlainArgs): GetGatewaySmbUsersResult =
        getGatewaySmbUsersResultToKotlin(getGatewaySmbUsersPlain(argument.toJava()).await())

    /**
     * @see [getGatewaySmbUsers].
     * @param gatewayId The Gateway ID.
     * @param ids A list of Gateway SMB User IDs.
     * @param nameRegex A regex string to filter results by Gateway SMB username.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getGatewaySmbUsers.
     */
    public suspend fun getGatewaySmbUsers(
        gatewayId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetGatewaySmbUsersResult {
        val argument = GetGatewaySmbUsersPlainArgs(
            gatewayId = gatewayId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getGatewaySmbUsersResultToKotlin(getGatewaySmbUsersPlain(argument.toJava()).await())
    }

    /**
     * @see [getGatewaySmbUsers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudstoragegateway&#46;kotlin&#46;inputs&#46;GetGatewaySmbUsersPlainArgs].
     * @return A collection of values returned by getGatewaySmbUsers.
     */
    public suspend fun getGatewaySmbUsers(argument: suspend GetGatewaySmbUsersPlainArgsBuilder.() -> Unit): GetGatewaySmbUsersResult {
        val builder = GetGatewaySmbUsersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewaySmbUsersResultToKotlin(getGatewaySmbUsersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cloud Storage Gateway Gateways of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.132.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = new alicloud.cloudstoragegateway.StorageBundle("example", {storageBundleName: "example_value"});
     * const nameRegex = alicloud.cloudstoragegateway.getGatewaysOutput({
     *     storageBundleId: example.id,
     *     nameRegex: "^my-Gateway",
     * });
     * export const cloudStorageGatewayGatewayId = nameRegex.apply(nameRegex => nameRegex.gateways?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cloudstoragegateway.StorageBundle("example", storage_bundle_name="example_value")
     * name_regex = alicloud.cloudstoragegateway.get_gateways_output(storage_bundle_id=example.id,
     *     name_regex="^my-Gateway")
     * pulumi.export("cloudStorageGatewayGatewayId", name_regex.gateways[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = new AliCloud.CloudStorageGateway.StorageBundle("example", new()
     *     {
     *         StorageBundleName = "example_value",
     *     });
     *     var nameRegex = AliCloud.CloudStorageGateway.GetGateways.Invoke(new()
     *     {
     *         StorageBundleId = example.Id,
     *         NameRegex = "^my-Gateway",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cloudStorageGatewayGatewayId"] = nameRegex&#46;Apply(getGatewaysResult => getGatewaysResult&#46;Gateways[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudstoragegateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cloudstoragegateway.NewStorageBundle(ctx, "example", &cloudstoragegateway.StorageBundleArgs{
     * 			StorageBundleName: pulumi.String("example_value"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		nameRegex := cloudstoragegateway.GetGatewaysOutput(ctx, cloudstoragegateway.GetGatewaysOutputArgs{
     * 			StorageBundleId: example.ID(),
     * 			NameRegex:       pulumi.String("^my-Gateway"),
     * 		}, nil)
     * 		ctx.Export("cloudStorageGatewayGatewayId", nameRegex.ApplyT(func(nameRegex cloudstoragegateway.GetGatewaysResult) (*string, error) {
     * 			return &nameRegex.Gateways[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudstoragegateway.StorageBundle;
     * import com.pulumi.alicloud.cloudstoragegateway.StorageBundleArgs;
     * import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions;
     * import com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewaysArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var example = new StorageBundle("example", StorageBundleArgs.builder()
     *             .storageBundleName("example_value")
     *             .build());
     *         final var nameRegex = CloudstoragegatewayFunctions.getGateways(GetGatewaysArgs.builder()
     *             .storageBundleId(example.id())
     *             .nameRegex("^my-Gateway")
     *             .build());
     *         ctx.export("cloudStorageGatewayGatewayId", nameRegex.applyValue(getGatewaysResult -> getGatewaysResult).applyValue(nameRegex -> nameRegex.applyValue(getGatewaysResult -> getGatewaysResult.gateways()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   example:
     *     type: alicloud:cloudstoragegateway:StorageBundle
     *     properties:
     *       storageBundleName: example_value
     * variables:
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cloudstoragegateway:getGateways
     *       Arguments:
     *         storageBundleId: ${example.id}
     *         nameRegex: ^my-Gateway
     * outputs:
     *   cloudStorageGatewayGatewayId: ${nameRegex.gateways[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGateways.
     * @return A collection of values returned by getGateways.
     */
    public suspend fun getGateways(argument: GetGatewaysPlainArgs): GetGatewaysResult =
        getGatewaysResultToKotlin(getGatewaysPlain(argument.toJava()).await())

    /**
     * @see [getGateways].
     * @param ids A list of Gateway IDs.
     * @param nameRegex A regex string to filter results by Gateway name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status gateway status.
     * @param storageBundleId storage bundle id.
     * @return A collection of values returned by getGateways.
     */
    public suspend fun getGateways(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
        storageBundleId: String,
    ): GetGatewaysResult {
        val argument = GetGatewaysPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
            storageBundleId = storageBundleId,
        )
        return getGatewaysResultToKotlin(getGatewaysPlain(argument.toJava()).await())
    }

    /**
     * @see [getGateways].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudstoragegateway&#46;kotlin&#46;inputs&#46;GetGatewaysPlainArgs].
     * @return A collection of values returned by getGateways.
     */
    public suspend fun getGateways(argument: suspend GetGatewaysPlainArgsBuilder.() -> Unit): GetGatewaysResult {
        val builder = GetGatewaysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewaysResultToKotlin(getGatewaysPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open Cloud Storage Gateway service automatically. If the service has been opened, it will return opened.
     * For information about Cloud Storage Gateway and how to use it, see [What is Cloud Storage Gateway](https://www.alibabacloud.com/help/en/product/53923.htm).
     * > **NOTE:** Available in v1.117.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.cloudstoragegateway.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.cloudstoragegateway.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.CloudStorageGateway.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudstoragegateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudstoragegateway.GetService(ctx, &cloudstoragegateway.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions;
     * import com.pulumi.alicloud.cloudstoragegateway.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = CloudstoragegatewayFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:cloudstoragegateway:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * > **NOTE:** Setting `enable = "On"` to open the Cloud Storage Gateway service that means you have read and agreed the [Cloud Storage Gateway Terms of Service](https://help.aliyun.com/document_detail/117679.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudstoragegateway&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cloud Storage Gateway Stocks of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.144.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cloudstoragegateway.getStocks({
     *     gatewayClass: "Advanced",
     * });
     * export const zoneId = _default.then(_default => _default.stocks?.[0]?.zoneId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cloudstoragegateway.get_stocks(gateway_class="Advanced")
     * pulumi.export("zoneId", default.stocks[0].zone_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.CloudStorageGateway.GetStocks.Invoke(new()
     *     {
     *         GatewayClass = "Advanced",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["zoneId"] = @default&#46;Apply(@default => @default&#46;Apply(getStocksResult => getStocksResult&#46;Stocks[0]?.ZoneId)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudstoragegateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := cloudstoragegateway.GetStocks(ctx, &cloudstoragegateway.GetStocksArgs{
     * 			GatewayClass: pulumi.StringRef("Advanced"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("zoneId", _default.Stocks[0].ZoneId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cloudstoragegateway.CloudstoragegatewayFunctions;
     * import com.pulumi.alicloud.cloudstoragegateway.inputs.GetStocksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CloudstoragegatewayFunctions.getStocks(GetStocksArgs.builder()
     *             .gatewayClass("Advanced")
     *             .build());
     *         ctx.export("zoneId", default_.stocks()[0].zoneId());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cloudstoragegateway:getStocks
     *       Arguments:
     *         gatewayClass: Advanced
     * outputs:
     *   zoneId: ${default.stocks[0].zoneId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getStocks.
     * @return A collection of values returned by getStocks.
     */
    public suspend fun getStocks(argument: GetStocksPlainArgs): GetStocksResult =
        getStocksResultToKotlin(getStocksPlain(argument.toJava()).await())

    /**
     * @see [getStocks].
     * @param gatewayClass The gateway class. Valid values: `Basic`, `Standard`,`Enhanced`,`Advanced`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getStocks.
     */
    public suspend fun getStocks(gatewayClass: String? = null, outputFile: String? = null): GetStocksResult {
        val argument = GetStocksPlainArgs(
            gatewayClass = gatewayClass,
            outputFile = outputFile,
        )
        return getStocksResultToKotlin(getStocksPlain(argument.toJava()).await())
    }

    /**
     * @see [getStocks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudstoragegateway&#46;kotlin&#46;inputs&#46;GetStocksPlainArgs].
     * @return A collection of values returned by getStocks.
     */
    public suspend fun getStocks(argument: suspend GetStocksPlainArgsBuilder.() -> Unit): GetStocksResult {
        val builder = GetStocksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStocksResultToKotlin(getStocksPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * @param argument A collection of arguments for invoking getStorageBundles.
     * @return A collection of values returned by getStorageBundles.
     */
    public suspend fun getStorageBundles(argument: GetStorageBundlesPlainArgs): GetStorageBundlesResult =
        getStorageBundlesResultToKotlin(getStorageBundlesPlain(argument.toJava()).await())

    /**
     * @see [getStorageBundles].
     * @param backendBucketRegionId
     * @param ids
     * @param nameRegex
     * @param outputFile
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getStorageBundles.
     */
    public suspend fun getStorageBundles(
        backendBucketRegionId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetStorageBundlesResult {
        val argument = GetStorageBundlesPlainArgs(
            backendBucketRegionId = backendBucketRegionId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getStorageBundlesResultToKotlin(getStorageBundlesPlain(argument.toJava()).await())
    }

    /**
     * @see [getStorageBundles].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cloudstoragegateway&#46;kotlin&#46;inputs&#46;GetStorageBundlesPlainArgs].
     * @return A collection of values returned by getStorageBundles.
     */
    public suspend fun getStorageBundles(argument: suspend GetStorageBundlesPlainArgsBuilder.() -> Unit): GetStorageBundlesResult {
        val builder = GetStorageBundlesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStorageBundlesResultToKotlin(getStorageBundlesPlain(builtArgument.toJava()).await())
    }
}
