@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ExpressSync].
 */
@PulumiTagMarker
public class ExpressSyncResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExpressSyncArgs = ExpressSyncArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExpressSyncArgsBuilder.() -> Unit) {
        val builder = ExpressSyncArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ExpressSync {
        val builtJavaResource =
            com.pulumi.alicloud.cloudstoragegateway.ExpressSync(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ExpressSync(builtJavaResource)
    }
}

/**
 * Provides a Cloud Storage Gateway Express Sync resource.
 * For information about Cloud Storage Gateway Express Sync and how to use it, see [What is Express Sync](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/xzpxo3).
 * > **NOTE:** Available since v1.144.0.
 * ## Import
 * Cloud Storage Gateway Express Sync can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/expressSync:ExpressSync example <id>
 * ```
 */
public class ExpressSync internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudstoragegateway.ExpressSync,
) : KotlinCustomResource(javaResource, ExpressSyncMapper) {
    /**
     * The name of the OSS Bucket.
     */
    public val bucketName: Output<String>
        get() = javaResource.bucketName().applyValue({ args0 -> args0 })

    /**
     * The prefix of the OSS Bucket.
     */
    public val bucketPrefix: Output<String>?
        get() = javaResource.bucketPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The region of the OSS Bucket.
     */
    public val bucketRegion: Output<String>
        get() = javaResource.bucketRegion().applyValue({ args0 -> args0 })

    /**
     * The description of the Express Sync. The length of the name is limited to `1` to `255` characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the ExpressSync. The length of the name is limited to `1` to `128` characters. It can contain uppercase and lowercase letters, Chinese characters, numbers, English periods (.), underscores (_), or hyphens (-), and must start with  letters.
     */
    public val expressSyncName: Output<String>
        get() = javaResource.expressSyncName().applyValue({ args0 -> args0 })
}

public object ExpressSyncMapper : ResourceMapper<ExpressSync> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudstoragegateway.ExpressSync::class == javaResource::class

    override fun map(javaResource: Resource): ExpressSync = ExpressSync(
        javaResource as
            com.pulumi.alicloud.cloudstoragegateway.ExpressSync,
    )
}

/**
 * @see [ExpressSync].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExpressSync].
 */
public suspend fun expressSync(name: String, block: suspend ExpressSyncResourceBuilder.() -> Unit): ExpressSync {
    val builder = ExpressSyncResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExpressSync].
 * @param name The _unique_ name of the resulting resource.
 */
public fun expressSync(name: String): ExpressSync {
    val builder = ExpressSyncResourceBuilder()
    builder.name(name)
    return builder.build()
}
