@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.alicloud.cloudstoragegateway.ExpressSyncArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Storage Gateway Express Sync resource.
 * For information about Cloud Storage Gateway Express Sync and how to use it, see [What is Express Sync](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/xzpxo3).
 * > **NOTE:** Available since v1.144.0.
 * ## Import
 * Cloud Storage Gateway Express Sync can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/expressSync:ExpressSync example <id>
 * ```
 * @property bucketName The name of the OSS Bucket.
 * @property bucketPrefix The prefix of the OSS Bucket.
 * @property bucketRegion The region of the OSS Bucket.
 * @property description The description of the Express Sync. The length of the name is limited to `1` to `255` characters.
 * @property expressSyncName The name of the ExpressSync. The length of the name is limited to `1` to `128` characters. It can contain uppercase and lowercase letters, Chinese characters, numbers, English periods (.), underscores (_), or hyphens (-), and must start with  letters.
 */
public data class ExpressSyncArgs(
    public val bucketName: Output<String>? = null,
    public val bucketPrefix: Output<String>? = null,
    public val bucketRegion: Output<String>? = null,
    public val description: Output<String>? = null,
    public val expressSyncName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.ExpressSyncArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.ExpressSyncArgs =
        com.pulumi.alicloud.cloudstoragegateway.ExpressSyncArgs.builder()
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
            .bucketRegion(bucketRegion?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .expressSyncName(expressSyncName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressSyncArgs].
 */
@PulumiTagMarker
public class ExpressSyncArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    private var bucketRegion: Output<String>? = null

    private var description: Output<String>? = null

    private var expressSyncName: Output<String>? = null

    /**
     * @param value The name of the OSS Bucket.
     */
    @JvmName("vbsrrumiaumrblqx")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The prefix of the OSS Bucket.
     */
    @JvmName("ufgrcxjfscfaxsin")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value The region of the OSS Bucket.
     */
    @JvmName("lqpplldmgkqegjxy")
    public suspend fun bucketRegion(`value`: Output<String>) {
        this.bucketRegion = value
    }

    /**
     * @param value The description of the Express Sync. The length of the name is limited to `1` to `255` characters.
     */
    @JvmName("kcripsdillqyovsi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the ExpressSync. The length of the name is limited to `1` to `128` characters. It can contain uppercase and lowercase letters, Chinese characters, numbers, English periods (.), underscores (_), or hyphens (-), and must start with  letters.
     */
    @JvmName("ybcwtsrrxinatlhb")
    public suspend fun expressSyncName(`value`: Output<String>) {
        this.expressSyncName = value
    }

    /**
     * @param value The name of the OSS Bucket.
     */
    @JvmName("hsduergissokwdoo")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The prefix of the OSS Bucket.
     */
    @JvmName("iulpprqpyvhlmusp")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value The region of the OSS Bucket.
     */
    @JvmName("hmbmuhyfqkeyxhyq")
    public suspend fun bucketRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketRegion = mapped
    }

    /**
     * @param value The description of the Express Sync. The length of the name is limited to `1` to `255` characters.
     */
    @JvmName("nhosxdopyciyxkwd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the ExpressSync. The length of the name is limited to `1` to `128` characters. It can contain uppercase and lowercase letters, Chinese characters, numbers, English periods (.), underscores (_), or hyphens (-), and must start with  letters.
     */
    @JvmName("imxhglgvqsdstdro")
    public suspend fun expressSyncName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressSyncName = mapped
    }

    internal fun build(): ExpressSyncArgs = ExpressSyncArgs(
        bucketName = bucketName,
        bucketPrefix = bucketPrefix,
        bucketRegion = bucketRegion,
        description = description,
        expressSyncName = expressSyncName,
    )
}
