@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ExpressSyncShareAttachment].
 */
@PulumiTagMarker
public class ExpressSyncShareAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExpressSyncShareAttachmentArgs = ExpressSyncShareAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExpressSyncShareAttachmentArgsBuilder.() -> Unit) {
        val builder = ExpressSyncShareAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ExpressSyncShareAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.cloudstoragegateway.ExpressSyncShareAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ExpressSyncShareAttachment(builtJavaResource)
    }
}

/**
 * Provides a Cloud Storage Gateway Express Sync Share Attachment resource.
 * For information about Cloud Storage Gateway Express Sync Share Attachment and how to use it, see [What is Express Sync Share Attachment](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/addsharestoexpresssync).
 * > **NOTE:** Available since v1.144.0.
 * ## Import
 * Cloud Storage Gateway Express Sync Share Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/expressSyncShareAttachment:ExpressSyncShareAttachment example <express_sync_id>:<gateway_id>:<share_name>
 * ```
 */
public class ExpressSyncShareAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudstoragegateway.ExpressSyncShareAttachment,
) : KotlinCustomResource(javaResource, ExpressSyncShareAttachmentMapper) {
    /**
     * The ID of the ExpressSync.
     */
    public val expressSyncId: Output<String>
        get() = javaResource.expressSyncId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Gateway.
     */
    public val gatewayId: Output<String>
        get() = javaResource.gatewayId().applyValue({ args0 -> args0 })

    /**
     * The name of the GatewayFileShare. **NOTE:** When GatewayFileShare is associated with a speed sync group, its reverse synchronization function will be turned off by default.
     */
    public val shareName: Output<String>
        get() = javaResource.shareName().applyValue({ args0 -> args0 })
}

public object ExpressSyncShareAttachmentMapper : ResourceMapper<ExpressSyncShareAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudstoragegateway.ExpressSyncShareAttachment::class == javaResource::class

    override fun map(javaResource: Resource): ExpressSyncShareAttachment =
        ExpressSyncShareAttachment(
            javaResource as
                com.pulumi.alicloud.cloudstoragegateway.ExpressSyncShareAttachment,
        )
}

/**
 * @see [ExpressSyncShareAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExpressSyncShareAttachment].
 */
public suspend fun expressSyncShareAttachment(
    name: String,
    block: suspend ExpressSyncShareAttachmentResourceBuilder.() -> Unit,
): ExpressSyncShareAttachment {
    val builder = ExpressSyncShareAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExpressSyncShareAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun expressSyncShareAttachment(name: String): ExpressSyncShareAttachment {
    val builder = ExpressSyncShareAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
