@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.alicloud.cloudstoragegateway.ExpressSyncShareAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Storage Gateway Express Sync Share Attachment resource.
 * For information about Cloud Storage Gateway Express Sync Share Attachment and how to use it, see [What is Express Sync Share Attachment](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/addsharestoexpresssync).
 * > **NOTE:** Available since v1.144.0.
 * ## Import
 * Cloud Storage Gateway Express Sync Share Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/expressSyncShareAttachment:ExpressSyncShareAttachment example <express_sync_id>:<gateway_id>:<share_name>
 * ```
 * @property expressSyncId The ID of the ExpressSync.
 * @property gatewayId The ID of the Gateway.
 * @property shareName The name of the GatewayFileShare. **NOTE:** When GatewayFileShare is associated with a speed sync group, its reverse synchronization function will be turned off by default.
 */
public data class ExpressSyncShareAttachmentArgs(
    public val expressSyncId: Output<String>? = null,
    public val gatewayId: Output<String>? = null,
    public val shareName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.ExpressSyncShareAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.ExpressSyncShareAttachmentArgs =
        com.pulumi.alicloud.cloudstoragegateway.ExpressSyncShareAttachmentArgs.builder()
            .expressSyncId(expressSyncId?.applyValue({ args0 -> args0 }))
            .gatewayId(gatewayId?.applyValue({ args0 -> args0 }))
            .shareName(shareName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressSyncShareAttachmentArgs].
 */
@PulumiTagMarker
public class ExpressSyncShareAttachmentArgsBuilder internal constructor() {
    private var expressSyncId: Output<String>? = null

    private var gatewayId: Output<String>? = null

    private var shareName: Output<String>? = null

    /**
     * @param value The ID of the ExpressSync.
     */
    @JvmName("xdhowcpabiqownbx")
    public suspend fun expressSyncId(`value`: Output<String>) {
        this.expressSyncId = value
    }

    /**
     * @param value The ID of the Gateway.
     */
    @JvmName("lkmaebrjwxpuegcr")
    public suspend fun gatewayId(`value`: Output<String>) {
        this.gatewayId = value
    }

    /**
     * @param value The name of the GatewayFileShare. **NOTE:** When GatewayFileShare is associated with a speed sync group, its reverse synchronization function will be turned off by default.
     */
    @JvmName("hxnyhstyvtavoglt")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value The ID of the ExpressSync.
     */
    @JvmName("xpbdmjybkfpfdmjj")
    public suspend fun expressSyncId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressSyncId = mapped
    }

    /**
     * @param value The ID of the Gateway.
     */
    @JvmName("rlxoxxxxqgytywtt")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayId = mapped
    }

    /**
     * @param value The name of the GatewayFileShare. **NOTE:** When GatewayFileShare is associated with a speed sync group, its reverse synchronization function will be turned off by default.
     */
    @JvmName("gsnttomouicknjyy")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    internal fun build(): ExpressSyncShareAttachmentArgs = ExpressSyncShareAttachmentArgs(
        expressSyncId = expressSyncId,
        gatewayId = gatewayId,
        shareName = shareName,
    )
}
