@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Gateway].
 */
@PulumiTagMarker
public class GatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayArgs = GatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayArgsBuilder.() -> Unit) {
        val builder = GatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Gateway {
        val builtJavaResource = com.pulumi.alicloud.cloudstoragegateway.Gateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Gateway(builtJavaResource)
    }
}

/**
 * Provides a Cloud Storage Gateway Gateway resource.
 * For information about Cloud Storage Gateway Gateway and how to use it, see [What is Gateway](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/deploygateway).
 * > **NOTE:** Available since v1.132.0.
 * ## Import
 * Cloud Storage Gateway Gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/gateway:Gateway example <id>
 * ```
 */
public class Gateway internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudstoragegateway.Gateway,
) : KotlinCustomResource(javaResource, GatewayMapper) {
    /**
     * The description of the gateway.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The specification of the gateway. Valid values: `Basic`, `Standard`,`Enhanced`,`Advanced`.
     */
    public val gatewayClass: Output<String>?
        get() = javaResource.gatewayClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the gateway.
     */
    public val gatewayName: Output<String>
        get() = javaResource.gatewayName().applyValue({ args0 -> args0 })

    /**
     * The location of the gateway. Valid values: `Cloud`, `On_Premise`.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The Payment type of gateway. Valid values: `PayAsYouGo`.
     */
    public val paymentType: Output<String>?
        get() = javaResource.paymentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The public network bandwidth of gateway. Default value: `5`. Valid values: `5` to `200`.
     */
    public val publicNetworkBandwidth: Output<Int>
        get() = javaResource.publicNetworkBandwidth().applyValue({ args0 -> args0 })

    /**
     * The reason detail of gateway.
     */
    public val reasonDetail: Output<String>?
        get() = javaResource.reasonDetail().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The reason type when user deletes the gateway.
     */
    public val reasonType: Output<String>?
        get() = javaResource.reasonType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to release the gateway due to expiration.
     */
    public val releaseAfterExpiration: Output<Boolean>?
        get() = javaResource.releaseAfterExpiration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the Gateway.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of the gateway cluster.
     */
    public val storageBundleId: Output<String>
        get() = javaResource.storageBundleId().applyValue({ args0 -> args0 })

    /**
     * The type of the gateway. Valid values: `File`, `Iscsi`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The ID of the vSwitch.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object GatewayMapper : ResourceMapper<Gateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudstoragegateway.Gateway::class == javaResource::class

    override fun map(javaResource: Resource): Gateway = Gateway(
        javaResource as
            com.pulumi.alicloud.cloudstoragegateway.Gateway,
    )
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Gateway].
 */
public suspend fun gateway(name: String, block: suspend GatewayResourceBuilder.() -> Unit): Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gateway(name: String): Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
