@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.alicloud.cloudstoragegateway.GatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Storage Gateway Gateway resource.
 * For information about Cloud Storage Gateway Gateway and how to use it, see [What is Gateway](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/deploygateway).
 * > **NOTE:** Available since v1.132.0.
 * ## Import
 * Cloud Storage Gateway Gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/gateway:Gateway example <id>
 * ```
 * @property description The description of the gateway.
 * @property gatewayClass The specification of the gateway. Valid values: `Basic`, `Standard`,`Enhanced`,`Advanced`.
 * @property gatewayName The name of the gateway.
 * @property location The location of the gateway. Valid values: `Cloud`, `On_Premise`.
 * @property paymentType The Payment type of gateway. Valid values: `PayAsYouGo`.
 * @property publicNetworkBandwidth The public network bandwidth of gateway. Default value: `5`. Valid values: `5` to `200`.
 * @property reasonDetail The reason detail of gateway.
 * @property reasonType The reason type when user deletes the gateway.
 * @property releaseAfterExpiration Whether to release the gateway due to expiration.
 * @property storageBundleId The ID of the gateway cluster.
 * @property type The type of the gateway. Valid values: `File`, `Iscsi`.
 * @property vswitchId The ID of the vSwitch.
 */
public data class GatewayArgs(
    public val description: Output<String>? = null,
    public val gatewayClass: Output<String>? = null,
    public val gatewayName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val publicNetworkBandwidth: Output<Int>? = null,
    public val reasonDetail: Output<String>? = null,
    public val reasonType: Output<String>? = null,
    public val releaseAfterExpiration: Output<Boolean>? = null,
    public val storageBundleId: Output<String>? = null,
    public val type: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.GatewayArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.GatewayArgs =
        com.pulumi.alicloud.cloudstoragegateway.GatewayArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .gatewayClass(gatewayClass?.applyValue({ args0 -> args0 }))
            .gatewayName(gatewayName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .publicNetworkBandwidth(publicNetworkBandwidth?.applyValue({ args0 -> args0 }))
            .reasonDetail(reasonDetail?.applyValue({ args0 -> args0 }))
            .reasonType(reasonType?.applyValue({ args0 -> args0 }))
            .releaseAfterExpiration(releaseAfterExpiration?.applyValue({ args0 -> args0 }))
            .storageBundleId(storageBundleId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayArgs].
 */
@PulumiTagMarker
public class GatewayArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var gatewayClass: Output<String>? = null

    private var gatewayName: Output<String>? = null

    private var location: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var publicNetworkBandwidth: Output<Int>? = null

    private var reasonDetail: Output<String>? = null

    private var reasonType: Output<String>? = null

    private var releaseAfterExpiration: Output<Boolean>? = null

    private var storageBundleId: Output<String>? = null

    private var type: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The description of the gateway.
     */
    @JvmName("gbyaupcdemlefyps")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The specification of the gateway. Valid values: `Basic`, `Standard`,`Enhanced`,`Advanced`.
     */
    @JvmName("gbpwbnsdxnvdenyb")
    public suspend fun gatewayClass(`value`: Output<String>) {
        this.gatewayClass = value
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("rsxenpccrfnlglhy")
    public suspend fun gatewayName(`value`: Output<String>) {
        this.gatewayName = value
    }

    /**
     * @param value The location of the gateway. Valid values: `Cloud`, `On_Premise`.
     */
    @JvmName("ednundrqkwbfeauq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The Payment type of gateway. Valid values: `PayAsYouGo`.
     */
    @JvmName("qggdbemwnsnyuvlu")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The public network bandwidth of gateway. Default value: `5`. Valid values: `5` to `200`.
     */
    @JvmName("rwcbbbfkrujmuirr")
    public suspend fun publicNetworkBandwidth(`value`: Output<Int>) {
        this.publicNetworkBandwidth = value
    }

    /**
     * @param value The reason detail of gateway.
     */
    @JvmName("elcoypvyhlllvfwo")
    public suspend fun reasonDetail(`value`: Output<String>) {
        this.reasonDetail = value
    }

    /**
     * @param value The reason type when user deletes the gateway.
     */
    @JvmName("raomsmkenwhhhqka")
    public suspend fun reasonType(`value`: Output<String>) {
        this.reasonType = value
    }

    /**
     * @param value Whether to release the gateway due to expiration.
     */
    @JvmName("ojxbnksxynwkvleb")
    public suspend fun releaseAfterExpiration(`value`: Output<Boolean>) {
        this.releaseAfterExpiration = value
    }

    /**
     * @param value The ID of the gateway cluster.
     */
    @JvmName("xfwusbkkdlnbbtvq")
    public suspend fun storageBundleId(`value`: Output<String>) {
        this.storageBundleId = value
    }

    /**
     * @param value The type of the gateway. Valid values: `File`, `Iscsi`.
     */
    @JvmName("xrjdprfawtbvepbp")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The ID of the vSwitch.
     */
    @JvmName("ihsnwskrmoahcusd")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The description of the gateway.
     */
    @JvmName("glijpqrtpoijqvmb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The specification of the gateway. Valid values: `Basic`, `Standard`,`Enhanced`,`Advanced`.
     */
    @JvmName("oqcrnxtnllrmujci")
    public suspend fun gatewayClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayClass = mapped
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("nmwcbvcoeupduhsr")
    public suspend fun gatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayName = mapped
    }

    /**
     * @param value The location of the gateway. Valid values: `Cloud`, `On_Premise`.
     */
    @JvmName("hlmiqqkndghuwjqu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The Payment type of gateway. Valid values: `PayAsYouGo`.
     */
    @JvmName("jjmnmxwjyymhxwgs")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The public network bandwidth of gateway. Default value: `5`. Valid values: `5` to `200`.
     */
    @JvmName("jomdhhvqisigfmty")
    public suspend fun publicNetworkBandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkBandwidth = mapped
    }

    /**
     * @param value The reason detail of gateway.
     */
    @JvmName("dbymlypwfvtyrkyp")
    public suspend fun reasonDetail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reasonDetail = mapped
    }

    /**
     * @param value The reason type when user deletes the gateway.
     */
    @JvmName("uwlgpgeuucwctbxb")
    public suspend fun reasonType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reasonType = mapped
    }

    /**
     * @param value Whether to release the gateway due to expiration.
     */
    @JvmName("epoavgpvcubdxjlv")
    public suspend fun releaseAfterExpiration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseAfterExpiration = mapped
    }

    /**
     * @param value The ID of the gateway cluster.
     */
    @JvmName("bjyllqpmwcssmuvy")
    public suspend fun storageBundleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageBundleId = mapped
    }

    /**
     * @param value The type of the gateway. Valid values: `File`, `Iscsi`.
     */
    @JvmName("qevlkwmblthigygr")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The ID of the vSwitch.
     */
    @JvmName("ymbywcryfvvbyptm")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): GatewayArgs = GatewayArgs(
        description = description,
        gatewayClass = gatewayClass,
        gatewayName = gatewayName,
        location = location,
        paymentType = paymentType,
        publicNetworkBandwidth = publicNetworkBandwidth,
        reasonDetail = reasonDetail,
        reasonType = reasonType,
        releaseAfterExpiration = releaseAfterExpiration,
        storageBundleId = storageBundleId,
        type = type,
        vswitchId = vswitchId,
    )
}
