@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GatewayBlockVolume].
 */
@PulumiTagMarker
public class GatewayBlockVolumeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayBlockVolumeArgs = GatewayBlockVolumeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayBlockVolumeArgsBuilder.() -> Unit) {
        val builder = GatewayBlockVolumeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GatewayBlockVolume {
        val builtJavaResource =
            com.pulumi.alicloud.cloudstoragegateway.GatewayBlockVolume(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GatewayBlockVolume(builtJavaResource)
    }
}

/**
 * Provides a Cloud Storage Gateway Gateway Block Volume resource.
 * For information about Cloud Storage Gateway Gateway Block Volume and how to use it, see [What is Gateway Block Volume](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewayblockvolume).
 * > **NOTE:** Available since v1.144.0.
 * ## Import
 * Cloud Storage Gateway Gateway Block Volume can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/gatewayBlockVolume:GatewayBlockVolume example <gateway_id>:<index_id>
 * ```
 */
public class GatewayBlockVolume internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudstoragegateway.GatewayBlockVolume,
) : KotlinCustomResource(javaResource, GatewayBlockVolumeMapper) {
    /**
     * The Block volume set mode to cache mode. Valid values: `Cache`, `WriteThrough`.
     */
    public val cacheMode: Output<String>
        get() = javaResource.cacheMode().applyValue({ args0 -> args0 })

    /**
     * Whether to enable iSCSI access of CHAP authentication, which currently supports both CHAP inbound authentication.  Default value: `false`.
     */
    public val chapEnabled: Output<Boolean>
        get() = javaResource.chapEnabled().applyValue({ args0 -> args0 })

    /**
     * The password for inbound authentication when the block volume enables iSCSI access to CHAP authentication. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
     */
    public val chapInPassword: Output<String>?
        get() = javaResource.chapInPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Inbound CHAP user. The `chap_in_user` must be 1 to 32 characters in length, and can contain letters and digits. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
     */
    public val chapInUser: Output<String>?
        get() = javaResource.chapInUser().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Block volume storage allocation unit.  Valid values: `8192`, `16384`, `32768`, `65536`, `131072`. Default value: `32768`. Unit: `Byte`.
     */
    public val chunkSize: Output<Int>
        get() = javaResource.chunkSize().applyValue({ args0 -> args0 })

    /**
     * The Block volume name. The name must be 1 to 32 characters in length, and can contain lower case letters and digits.
     */
    public val gatewayBlockVolumeName: Output<String>
        get() = javaResource.gatewayBlockVolumeName().applyValue({ args0 -> args0 })

    /**
     * The Gateway ID.
     */
    public val gatewayId: Output<String>
        get() = javaResource.gatewayId().applyValue({ args0 -> args0 })

    /**
     * The ID of the index.
     */
    public val indexId: Output<String>
        get() = javaResource.indexId().applyValue({ args0 -> args0 })

    /**
     * Whether to delete the source data. Default value `true`. **NOTE:** When `is_source_deletion` is `true`, the data in the OSS Bucket on the cloud is also deleted when deleting the block gateway volume. Please operate with caution.
     */
    public val isSourceDeletion: Output<Boolean>?
        get() = javaResource.isSourceDeletion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Cache disk to local path. **NOTE:**  When the `cache_mode` is  `Cache` is,The `chap_in_password` is valid.
     */
    public val localPath: Output<String>?
        get() = javaResource.localPath().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the OSS Bucket.
     */
    public val ossBucketName: Output<String>
        get() = javaResource.ossBucketName().applyValue({ args0 -> args0 })

    /**
     * Whether to enable SSL access your OSS Buckets. Default value: `true`.
     */
    public val ossBucketSsl: Output<Boolean>
        get() = javaResource.ossBucketSsl().applyValue({ args0 -> args0 })

    /**
     * The endpoint of the OSS Bucket.
     */
    public val ossEndpoint: Output<String>
        get() = javaResource.ossEndpoint().applyValue({ args0 -> args0 })

    /**
     * The Protocol. Valid values: `iSCSI`.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * The recovery.
     */
    public val recovery: Output<Boolean>?
        get() = javaResource.recovery().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Volume size. Valid values: `1` to `262144`. Unit: `Byte`.
     */
    public val size: Output<Int>
        get() = javaResource.size().applyValue({ args0 -> args0 })

    /**
     * The status of volume. Valid values:
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object GatewayBlockVolumeMapper : ResourceMapper<GatewayBlockVolume> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudstoragegateway.GatewayBlockVolume::class == javaResource::class

    override fun map(javaResource: Resource): GatewayBlockVolume = GatewayBlockVolume(
        javaResource as
            com.pulumi.alicloud.cloudstoragegateway.GatewayBlockVolume,
    )
}

/**
 * @see [GatewayBlockVolume].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewayBlockVolume].
 */
public suspend fun gatewayBlockVolume(
    name: String,
    block: suspend GatewayBlockVolumeResourceBuilder.() -> Unit,
): GatewayBlockVolume {
    val builder = GatewayBlockVolumeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewayBlockVolume].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewayBlockVolume(name: String): GatewayBlockVolume {
    val builder = GatewayBlockVolumeResourceBuilder()
    builder.name(name)
    return builder.build()
}
