@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.alicloud.cloudstoragegateway.GatewayBlockVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Storage Gateway Gateway Block Volume resource.
 * For information about Cloud Storage Gateway Gateway Block Volume and how to use it, see [What is Gateway Block Volume](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewayblockvolume).
 * > **NOTE:** Available since v1.144.0.
 * ## Import
 * Cloud Storage Gateway Gateway Block Volume can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/gatewayBlockVolume:GatewayBlockVolume example <gateway_id>:<index_id>
 * ```
 * @property cacheMode The Block volume set mode to cache mode. Valid values: `Cache`, `WriteThrough`.
 * @property chapEnabled Whether to enable iSCSI access of CHAP authentication, which currently supports both CHAP inbound authentication.  Default value: `false`.
 * @property chapInPassword The password for inbound authentication when the block volume enables iSCSI access to CHAP authentication. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
 * @property chapInUser The Inbound CHAP user. The `chap_in_user` must be 1 to 32 characters in length, and can contain letters and digits. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
 * @property chunkSize The Block volume storage allocation unit.  Valid values: `8192`, `16384`, `32768`, `65536`, `131072`. Default value: `32768`. Unit: `Byte`.
 * @property gatewayBlockVolumeName The Block volume name. The name must be 1 to 32 characters in length, and can contain lower case letters and digits.
 * @property gatewayId The Gateway ID.
 * @property isSourceDeletion Whether to delete the source data. Default value `true`. **NOTE:** When `is_source_deletion` is `true`, the data in the OSS Bucket on the cloud is also deleted when deleting the block gateway volume. Please operate with caution.
 * @property localPath The Cache disk to local path. **NOTE:**  When the `cache_mode` is  `Cache` is,The `chap_in_password` is valid.
 * @property ossBucketName The name of the OSS Bucket.
 * @property ossBucketSsl Whether to enable SSL access your OSS Buckets. Default value: `true`.
 * @property ossEndpoint The endpoint of the OSS Bucket.
 * @property protocol The Protocol. Valid values: `iSCSI`.
 * @property recovery The recovery.
 * @property size The Volume size. Valid values: `1` to `262144`. Unit: `Byte`.
 */
public data class GatewayBlockVolumeArgs(
    public val cacheMode: Output<String>? = null,
    public val chapEnabled: Output<Boolean>? = null,
    public val chapInPassword: Output<String>? = null,
    public val chapInUser: Output<String>? = null,
    public val chunkSize: Output<Int>? = null,
    public val gatewayBlockVolumeName: Output<String>? = null,
    public val gatewayId: Output<String>? = null,
    public val isSourceDeletion: Output<Boolean>? = null,
    public val localPath: Output<String>? = null,
    public val ossBucketName: Output<String>? = null,
    public val ossBucketSsl: Output<Boolean>? = null,
    public val ossEndpoint: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val recovery: Output<Boolean>? = null,
    public val size: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.GatewayBlockVolumeArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.GatewayBlockVolumeArgs =
        com.pulumi.alicloud.cloudstoragegateway.GatewayBlockVolumeArgs.builder()
            .cacheMode(cacheMode?.applyValue({ args0 -> args0 }))
            .chapEnabled(chapEnabled?.applyValue({ args0 -> args0 }))
            .chapInPassword(chapInPassword?.applyValue({ args0 -> args0 }))
            .chapInUser(chapInUser?.applyValue({ args0 -> args0 }))
            .chunkSize(chunkSize?.applyValue({ args0 -> args0 }))
            .gatewayBlockVolumeName(gatewayBlockVolumeName?.applyValue({ args0 -> args0 }))
            .gatewayId(gatewayId?.applyValue({ args0 -> args0 }))
            .isSourceDeletion(isSourceDeletion?.applyValue({ args0 -> args0 }))
            .localPath(localPath?.applyValue({ args0 -> args0 }))
            .ossBucketName(ossBucketName?.applyValue({ args0 -> args0 }))
            .ossBucketSsl(ossBucketSsl?.applyValue({ args0 -> args0 }))
            .ossEndpoint(ossEndpoint?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .recovery(recovery?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayBlockVolumeArgs].
 */
@PulumiTagMarker
public class GatewayBlockVolumeArgsBuilder internal constructor() {
    private var cacheMode: Output<String>? = null

    private var chapEnabled: Output<Boolean>? = null

    private var chapInPassword: Output<String>? = null

    private var chapInUser: Output<String>? = null

    private var chunkSize: Output<Int>? = null

    private var gatewayBlockVolumeName: Output<String>? = null

    private var gatewayId: Output<String>? = null

    private var isSourceDeletion: Output<Boolean>? = null

    private var localPath: Output<String>? = null

    private var ossBucketName: Output<String>? = null

    private var ossBucketSsl: Output<Boolean>? = null

    private var ossEndpoint: Output<String>? = null

    private var protocol: Output<String>? = null

    private var recovery: Output<Boolean>? = null

    private var size: Output<Int>? = null

    /**
     * @param value The Block volume set mode to cache mode. Valid values: `Cache`, `WriteThrough`.
     */
    @JvmName("mlptqnqjnulwtvho")
    public suspend fun cacheMode(`value`: Output<String>) {
        this.cacheMode = value
    }

    /**
     * @param value Whether to enable iSCSI access of CHAP authentication, which currently supports both CHAP inbound authentication.  Default value: `false`.
     */
    @JvmName("daxvcuvregrgxftj")
    public suspend fun chapEnabled(`value`: Output<Boolean>) {
        this.chapEnabled = value
    }

    /**
     * @param value The password for inbound authentication when the block volume enables iSCSI access to CHAP authentication. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
     */
    @JvmName("fudwyonoalwawyuh")
    public suspend fun chapInPassword(`value`: Output<String>) {
        this.chapInPassword = value
    }

    /**
     * @param value The Inbound CHAP user. The `chap_in_user` must be 1 to 32 characters in length, and can contain letters and digits. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
     */
    @JvmName("rcgqidxgnscugixv")
    public suspend fun chapInUser(`value`: Output<String>) {
        this.chapInUser = value
    }

    /**
     * @param value The Block volume storage allocation unit.  Valid values: `8192`, `16384`, `32768`, `65536`, `131072`. Default value: `32768`. Unit: `Byte`.
     */
    @JvmName("nwdcyeligbeckoqk")
    public suspend fun chunkSize(`value`: Output<Int>) {
        this.chunkSize = value
    }

    /**
     * @param value The Block volume name. The name must be 1 to 32 characters in length, and can contain lower case letters and digits.
     */
    @JvmName("emynutyoyklosqle")
    public suspend fun gatewayBlockVolumeName(`value`: Output<String>) {
        this.gatewayBlockVolumeName = value
    }

    /**
     * @param value The Gateway ID.
     */
    @JvmName("vwmqrhfsulosmhdo")
    public suspend fun gatewayId(`value`: Output<String>) {
        this.gatewayId = value
    }

    /**
     * @param value Whether to delete the source data. Default value `true`. **NOTE:** When `is_source_deletion` is `true`, the data in the OSS Bucket on the cloud is also deleted when deleting the block gateway volume. Please operate with caution.
     */
    @JvmName("jrhrltyhuiosttuu")
    public suspend fun isSourceDeletion(`value`: Output<Boolean>) {
        this.isSourceDeletion = value
    }

    /**
     * @param value The Cache disk to local path. **NOTE:**  When the `cache_mode` is  `Cache` is,The `chap_in_password` is valid.
     */
    @JvmName("sfxeiwmffrxfluof")
    public suspend fun localPath(`value`: Output<String>) {
        this.localPath = value
    }

    /**
     * @param value The name of the OSS Bucket.
     */
    @JvmName("khansjbbtofkqxyo")
    public suspend fun ossBucketName(`value`: Output<String>) {
        this.ossBucketName = value
    }

    /**
     * @param value Whether to enable SSL access your OSS Buckets. Default value: `true`.
     */
    @JvmName("cehjvvccbnloxqbq")
    public suspend fun ossBucketSsl(`value`: Output<Boolean>) {
        this.ossBucketSsl = value
    }

    /**
     * @param value The endpoint of the OSS Bucket.
     */
    @JvmName("pgqciyprlcokhdwo")
    public suspend fun ossEndpoint(`value`: Output<String>) {
        this.ossEndpoint = value
    }

    /**
     * @param value The Protocol. Valid values: `iSCSI`.
     */
    @JvmName("dtvjcbrjiptwqnxb")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The recovery.
     */
    @JvmName("wcjihlmdfgxudvbe")
    public suspend fun recovery(`value`: Output<Boolean>) {
        this.recovery = value
    }

    /**
     * @param value The Volume size. Valid values: `1` to `262144`. Unit: `Byte`.
     */
    @JvmName("ramrrrkwmwyukguo")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The Block volume set mode to cache mode. Valid values: `Cache`, `WriteThrough`.
     */
    @JvmName("wbimarcsosrstovh")
    public suspend fun cacheMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheMode = mapped
    }

    /**
     * @param value Whether to enable iSCSI access of CHAP authentication, which currently supports both CHAP inbound authentication.  Default value: `false`.
     */
    @JvmName("vfjcvxxjoqnuaapy")
    public suspend fun chapEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chapEnabled = mapped
    }

    /**
     * @param value The password for inbound authentication when the block volume enables iSCSI access to CHAP authentication. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
     */
    @JvmName("cudfolvodgfkbidv")
    public suspend fun chapInPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chapInPassword = mapped
    }

    /**
     * @param value The Inbound CHAP user. The `chap_in_user` must be 1 to 32 characters in length, and can contain letters and digits. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
     */
    @JvmName("smamgvigpwhhbnrd")
    public suspend fun chapInUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chapInUser = mapped
    }

    /**
     * @param value The Block volume storage allocation unit.  Valid values: `8192`, `16384`, `32768`, `65536`, `131072`. Default value: `32768`. Unit: `Byte`.
     */
    @JvmName("scxtwvoyhtigkwbr")
    public suspend fun chunkSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chunkSize = mapped
    }

    /**
     * @param value The Block volume name. The name must be 1 to 32 characters in length, and can contain lower case letters and digits.
     */
    @JvmName("hyddxksglibiflmx")
    public suspend fun gatewayBlockVolumeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayBlockVolumeName = mapped
    }

    /**
     * @param value The Gateway ID.
     */
    @JvmName("vmxupoqwxobhvwmc")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayId = mapped
    }

    /**
     * @param value Whether to delete the source data. Default value `true`. **NOTE:** When `is_source_deletion` is `true`, the data in the OSS Bucket on the cloud is also deleted when deleting the block gateway volume. Please operate with caution.
     */
    @JvmName("gmranregteqyyadm")
    public suspend fun isSourceDeletion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSourceDeletion = mapped
    }

    /**
     * @param value The Cache disk to local path. **NOTE:**  When the `cache_mode` is  `Cache` is,The `chap_in_password` is valid.
     */
    @JvmName("fjfnyxqwykudhxap")
    public suspend fun localPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localPath = mapped
    }

    /**
     * @param value The name of the OSS Bucket.
     */
    @JvmName("uybmotwujnvqjgbf")
    public suspend fun ossBucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossBucketName = mapped
    }

    /**
     * @param value Whether to enable SSL access your OSS Buckets. Default value: `true`.
     */
    @JvmName("uoiblsfaqgtdyfxn")
    public suspend fun ossBucketSsl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossBucketSsl = mapped
    }

    /**
     * @param value The endpoint of the OSS Bucket.
     */
    @JvmName("yusymehmvyjhkday")
    public suspend fun ossEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossEndpoint = mapped
    }

    /**
     * @param value The Protocol. Valid values: `iSCSI`.
     */
    @JvmName("psulqsjoisgkxcyj")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The recovery.
     */
    @JvmName("sdqpcmcwfchxyiqa")
    public suspend fun recovery(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recovery = mapped
    }

    /**
     * @param value The Volume size. Valid values: `1` to `262144`. Unit: `Byte`.
     */
    @JvmName("gycamgbbkjhhxgfu")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    internal fun build(): GatewayBlockVolumeArgs = GatewayBlockVolumeArgs(
        cacheMode = cacheMode,
        chapEnabled = chapEnabled,
        chapInPassword = chapInPassword,
        chapInUser = chapInUser,
        chunkSize = chunkSize,
        gatewayBlockVolumeName = gatewayBlockVolumeName,
        gatewayId = gatewayId,
        isSourceDeletion = isSourceDeletion,
        localPath = localPath,
        ossBucketName = ossBucketName,
        ossBucketSsl = ossBucketSsl,
        ossEndpoint = ossEndpoint,
        protocol = protocol,
        recovery = recovery,
        size = size,
    )
}
