@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GatewayCacheDisk].
 */
@PulumiTagMarker
public class GatewayCacheDiskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayCacheDiskArgs = GatewayCacheDiskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayCacheDiskArgsBuilder.() -> Unit) {
        val builder = GatewayCacheDiskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GatewayCacheDisk {
        val builtJavaResource =
            com.pulumi.alicloud.cloudstoragegateway.GatewayCacheDisk(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GatewayCacheDisk(builtJavaResource)
    }
}

/**
 * Provides a Cloud Storage Gateway Gateway Cache Disk resource.
 * For information about Cloud Storage Gateway Gateway Cache Disk and how to use it, see [What is Gateway Cache Disk](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewaycachedisk).
 * > **NOTE:** Available since v1.144.0.
 * ## Import
 * Cloud Storage Gateway Gateway Cache Disk can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/gatewayCacheDisk:GatewayCacheDisk example <gateway_id>:<cache_id>:<local_file_path>
 * ```
 */
public class GatewayCacheDisk internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudstoragegateway.GatewayCacheDisk,
) : KotlinCustomResource(javaResource, GatewayCacheDiskMapper) {
    /**
     * The type of the cache disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`. **NOTE:** From version 1.227.0, `cache_disk_category` can be set to `cloud_essd`.
     */
    public val cacheDiskCategory: Output<String>
        get() = javaResource.cacheDiskCategory().applyValue({ args0 -> args0 })

    /**
     * The capacity of the cache disk.
     */
    public val cacheDiskSizeInGb: Output<Int>
        get() = javaResource.cacheDiskSizeInGb().applyValue({ args0 -> args0 })

    /**
     * The ID of the cache disk.
     */
    public val cacheId: Output<String>
        get() = javaResource.cacheId().applyValue({ args0 -> args0 })

    /**
     * The ID of the gateway.
     */
    public val gatewayId: Output<String>
        get() = javaResource.gatewayId().applyValue({ args0 -> args0 })

    /**
     * The path of the cache disk.
     */
    public val localFilePath: Output<String>
        get() = javaResource.localFilePath().applyValue({ args0 -> args0 })

    /**
     * The performance level (PL) of the Enterprise SSD (ESSD). Valid values: `PL1`, `PL2`, `PL3`. **NOTE:** If `cache_disk_category` is set to `cloud_essd`, `performance_level` is required.
     */
    public val performanceLevel: Output<String>?
        get() = javaResource.performanceLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the Gateway Cache Disk.
     */
    public val status: Output<Int>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object GatewayCacheDiskMapper : ResourceMapper<GatewayCacheDisk> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudstoragegateway.GatewayCacheDisk::class == javaResource::class

    override fun map(javaResource: Resource): GatewayCacheDisk = GatewayCacheDisk(
        javaResource as
            com.pulumi.alicloud.cloudstoragegateway.GatewayCacheDisk,
    )
}

/**
 * @see [GatewayCacheDisk].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewayCacheDisk].
 */
public suspend fun gatewayCacheDisk(
    name: String,
    block: suspend GatewayCacheDiskResourceBuilder.() -> Unit,
): GatewayCacheDisk {
    val builder = GatewayCacheDiskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewayCacheDisk].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewayCacheDisk(name: String): GatewayCacheDisk {
    val builder = GatewayCacheDiskResourceBuilder()
    builder.name(name)
    return builder.build()
}
