@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.alicloud.cloudstoragegateway.GatewayCacheDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Storage Gateway Gateway Cache Disk resource.
 * For information about Cloud Storage Gateway Gateway Cache Disk and how to use it, see [What is Gateway Cache Disk](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewaycachedisk).
 * > **NOTE:** Available since v1.144.0.
 * ## Import
 * Cloud Storage Gateway Gateway Cache Disk can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/gatewayCacheDisk:GatewayCacheDisk example <gateway_id>:<cache_id>:<local_file_path>
 * ```
 * @property cacheDiskCategory The type of the cache disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`. **NOTE:** From version 1.227.0, `cache_disk_category` can be set to `cloud_essd`.
 * @property cacheDiskSizeInGb The capacity of the cache disk.
 * @property gatewayId The ID of the gateway.
 * @property performanceLevel The performance level (PL) of the Enterprise SSD (ESSD). Valid values: `PL1`, `PL2`, `PL3`. **NOTE:** If `cache_disk_category` is set to `cloud_essd`, `performance_level` is required.
 */
public data class GatewayCacheDiskArgs(
    public val cacheDiskCategory: Output<String>? = null,
    public val cacheDiskSizeInGb: Output<Int>? = null,
    public val gatewayId: Output<String>? = null,
    public val performanceLevel: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.GatewayCacheDiskArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.GatewayCacheDiskArgs =
        com.pulumi.alicloud.cloudstoragegateway.GatewayCacheDiskArgs.builder()
            .cacheDiskCategory(cacheDiskCategory?.applyValue({ args0 -> args0 }))
            .cacheDiskSizeInGb(cacheDiskSizeInGb?.applyValue({ args0 -> args0 }))
            .gatewayId(gatewayId?.applyValue({ args0 -> args0 }))
            .performanceLevel(performanceLevel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayCacheDiskArgs].
 */
@PulumiTagMarker
public class GatewayCacheDiskArgsBuilder internal constructor() {
    private var cacheDiskCategory: Output<String>? = null

    private var cacheDiskSizeInGb: Output<Int>? = null

    private var gatewayId: Output<String>? = null

    private var performanceLevel: Output<String>? = null

    /**
     * @param value The type of the cache disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`. **NOTE:** From version 1.227.0, `cache_disk_category` can be set to `cloud_essd`.
     */
    @JvmName("wbibegwmejmkjhme")
    public suspend fun cacheDiskCategory(`value`: Output<String>) {
        this.cacheDiskCategory = value
    }

    /**
     * @param value The capacity of the cache disk.
     */
    @JvmName("pxrxvcfuqvpwwtei")
    public suspend fun cacheDiskSizeInGb(`value`: Output<Int>) {
        this.cacheDiskSizeInGb = value
    }

    /**
     * @param value The ID of the gateway.
     */
    @JvmName("knlvjoafyaociary")
    public suspend fun gatewayId(`value`: Output<String>) {
        this.gatewayId = value
    }

    /**
     * @param value The performance level (PL) of the Enterprise SSD (ESSD). Valid values: `PL1`, `PL2`, `PL3`. **NOTE:** If `cache_disk_category` is set to `cloud_essd`, `performance_level` is required.
     */
    @JvmName("kqcgqbbpowveayyf")
    public suspend fun performanceLevel(`value`: Output<String>) {
        this.performanceLevel = value
    }

    /**
     * @param value The type of the cache disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`. **NOTE:** From version 1.227.0, `cache_disk_category` can be set to `cloud_essd`.
     */
    @JvmName("hqetplxouieftque")
    public suspend fun cacheDiskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheDiskCategory = mapped
    }

    /**
     * @param value The capacity of the cache disk.
     */
    @JvmName("naxqvsdyoyxwbjiw")
    public suspend fun cacheDiskSizeInGb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheDiskSizeInGb = mapped
    }

    /**
     * @param value The ID of the gateway.
     */
    @JvmName("jmrnsttnssnfcvqj")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayId = mapped
    }

    /**
     * @param value The performance level (PL) of the Enterprise SSD (ESSD). Valid values: `PL1`, `PL2`, `PL3`. **NOTE:** If `cache_disk_category` is set to `cloud_essd`, `performance_level` is required.
     */
    @JvmName("jsqnqkweaomchqos")
    public suspend fun performanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceLevel = mapped
    }

    internal fun build(): GatewayCacheDiskArgs = GatewayCacheDiskArgs(
        cacheDiskCategory = cacheDiskCategory,
        cacheDiskSizeInGb = cacheDiskSizeInGb,
        gatewayId = gatewayId,
        performanceLevel = performanceLevel,
    )
}
