@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GatewayFileShare].
 */
@PulumiTagMarker
public class GatewayFileShareResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayFileShareArgs = GatewayFileShareArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayFileShareArgsBuilder.() -> Unit) {
        val builder = GatewayFileShareArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GatewayFileShare {
        val builtJavaResource =
            com.pulumi.alicloud.cloudstoragegateway.GatewayFileShare(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GatewayFileShare(builtJavaResource)
    }
}

/**
 * Provides a Cloud Storage Gateway Gateway File Share resource.
 * For information about Cloud Storage Gateway Gateway File Share and how to use it, see [What is Gateway File Share](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewayfileshare).
 * > **NOTE:** Available since v1.144.0.
 * ## Import
 * Cloud Storage Gateway Gateway File Share can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/gatewayFileShare:GatewayFileShare example <gateway_id>:<index_id>
 * ```
 */
public class GatewayFileShare internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudstoragegateway.GatewayFileShare,
) : KotlinCustomResource(javaResource, GatewayFileShareMapper) {
    /**
     * Whether to enable Windows ABE, the prime minister, need windowsAcl parameter is set to true in the entry into force of. Default value: `false`. **NOTE:** The attribute is valid when the attribute `protocol` is `SMB`. Gateway version >= 1.0.45 above support.
     */
    public val accessBasedEnumeration: Output<Boolean>
        get() = javaResource.accessBasedEnumeration().applyValue({ args0 -> args0 })

    /**
     * The Max upload speed of the gateway file share. Unit: `MB/s`, 0 means unlimited. Value range: `0` ~ `1280`. Default value: `0`. **NOTE:** at the same time if you have to limit the maximum write speed, maximum upload speed is no less than the maximum write speed.
     */
    public val backendLimit: Output<Int>
        get() = javaResource.backendLimit().applyValue({ args0 -> args0 })

    /**
     * The whether browsable of the gateway file share (that is, in the network neighborhood of whether you can find). The attribute is valid when the attribute `protocol` is `SMB`. Default value: `true`.
     */
    public val browsable: Output<Boolean>
        get() = javaResource.browsable().applyValue({ args0 -> args0 })

    /**
     * Direct reading OSS of the gateway file share.
     */
    public val bypassCacheRead: Output<Boolean>
        get() = javaResource.bypassCacheRead().applyValue({ args0 -> args0 })

    /**
     * The set up gateway file share cache mode. Valid values: `Cache` or `Sync`. `Cache`: cached mode. `Sync`: replication mode are available. Default value: `Cache`.
     */
    public val cacheMode: Output<String>
        get() = javaResource.cacheMode().applyValue({ args0 -> args0 })

    /**
     * File sharing Whether to enable DirectIO (direct I/O mode for data transmission). Default value: `false`.
     */
    public val directIo: Output<Boolean>
        get() = javaResource.directIo().applyValue({ args0 -> args0 })

    /**
     * The maximum download speed of the gateway file share. Unit: `MB/s`. `0` means unlimited. Value range: `0` ~ `1280`. **NOTE:** only in copy mode and enable download file data can be set. only when the shared opens the reverse synchronization or acceded to by the speed synchronization Group when, this parameter will not take effect. Gateway version >= 1.3.0 above support.
     */
    public val downloadLimit: Output<Int>
        get() = javaResource.downloadLimit().applyValue({ args0 -> args0 })

    /**
     * The whether to enable Upload optimization of the gateway file share, which is suitable for data pure backup migration scenarios. Default value: `false`. **NOTE:** Gateway version >= 1.0.39 above support.
     */
    public val fastReclaim: Output<Boolean>
        get() = javaResource.fastReclaim().applyValue({ args0 -> args0 })

    /**
     * The maximum write speed of the gateway file share. Unit: `MB/s`, `0` means unlimited. Value range: `0` ~ `1280`. Default value: `0`.
     */
    public val feLimit: Output<Int>
        get() = javaResource.feLimit().applyValue({ args0 -> args0 })

    /**
     * The name of the file share. Length from `1` to `255` characters can contain lowercase letters, digits, (.), (_) Or (-), at the same time, must start with a lowercase letter.
     */
    public val gatewayFileShareName: Output<String>
        get() = javaResource.gatewayFileShareName().applyValue({ args0 -> args0 })

    /**
     * The ID of the gateway.
     */
    public val gatewayId: Output<String>
        get() = javaResource.gatewayId().applyValue({ args0 -> args0 })

    /**
     * The whether to ignore deleted of the gateway file share. After the opening of the Gateway side delete file or delete cloud (OSS) corresponding to the file. Default value: `false`. **NOTE:** `ignore_delete` and `remote_sync` cannot be enabled simultaneously. Gateway version >= 1.0.40 above support.
     */
    public val ignoreDelete: Output<Boolean>
        get() = javaResource.ignoreDelete().applyValue({ args0 -> args0 })

    /**
     * The whether debris optimization of the gateway file share. Default value: `false`.
     */
    public val inPlace: Output<Boolean>
        get() = javaResource.inPlace().applyValue({ args0 -> args0 })

    /**
     * The ID of the file share.
     */
    public val indexId: Output<String>
        get() = javaResource.indexId().applyValue({ args0 -> args0 })

    /**
     * The synchronization delay, I.e. gateway local cache sync to Alibaba Cloud Object Storage Service (oss) of the delay time. Unit: `Seconds`. Value range: `5` ~ `120`. Default value: `5`. **NOTE:** Gateway version >= 1.0.40 above support.
     */
    public val lagPeriod: Output<Int>
        get() = javaResource.lagPeriod().applyValue({ args0 -> args0 })

    /**
     * The cache disk inside the device name.
     */
    public val localPath: Output<String>
        get() = javaResource.localPath().applyValue({ args0 -> args0 })

    /**
     * The set up gateway file share NFS protocol, whether to enable NFS v4 optimization improve Mount Upload efficiency. Default value: `false`. **NOTE:** If it is enabled, NFS V3 cannot be mounted. The attribute is valid when the attribute `protocol` is `NFS`. Gateway version >= 1.2.0 above support.
     */
    public val nfsV4Optimization: Output<Boolean>
        get() = javaResource.nfsV4Optimization().applyValue({ args0 -> args0 })

    /**
     * The name of the OSS Bucket.
     */
    public val ossBucketName: Output<String>
        get() = javaResource.ossBucketName().applyValue({ args0 -> args0 })

    /**
     * Whether they are using SSL connect to OSS Bucket.
     */
    public val ossBucketSsl: Output<Boolean>
        get() = javaResource.ossBucketSsl().applyValue({ args0 -> args0 })

    /**
     * The gateway file share corresponds to the Object Storage SERVICE (OSS), Bucket Endpoint. **NOTE:** distinguish between intranet and internet Endpoint. We recommend that if the OSS Bucket and the gateway is in the same Region is use the RDS intranet IP Endpoint: `oss-cn-hangzhou-internal.aliyuncs.com`.
     */
    public val ossEndpoint: Output<String>
        get() = javaResource.ossEndpoint().applyValue({ args0 -> args0 })

    /**
     * In part mode, the directory path group JSON format.
     */
    public val partialSyncPaths: Output<String>?
        get() = javaResource.partialSyncPaths().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The subdirectory path under the object storage (OSS) bucket corresponding to the file share. If it is blank, it means the root directory of the bucket.
     */
    public val pathPrefix: Output<String>?
        get() = javaResource.pathPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The reverse synchronization time intervals of the gateway file share. Value range: `15` ~ `36000`. **NOTE:** in copy mode + reverse synchronization is enabled Download file data, value range: `3600` ~ `36000`.
     */
    public val pollingInterval: Output<Int>?
        get() = javaResource.pollingInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Share types. Valid values: `SMB`, `NFS`.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * Whether to enable reverse synchronization of the gateway file share. Default value: `false`.
     */
    public val remoteSync: Output<Boolean>
        get() = javaResource.remoteSync().applyValue({ args0 -> args0 })

    /**
     * Copy mode, whether to download the file data. Default value: `false`. **NOTE:** only when the attribute `remote_sync` is `true` or acceded to by the speed synchronization group, this parameter will not take effect.
     */
    public val remoteSyncDownload: Output<Boolean>
        get() = javaResource.remoteSyncDownload().applyValue({ args0 -> args0 })

    /**
     * File sharing NFS read-only client list (IP address or IP address range). Use commas (,) to separate multiple clients.
     */
    public val roClientList: Output<String>?
        get() = javaResource.roClientList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The read-only client list. When Protocol for Server Message Block (SMB) to go back to.
     */
    public val roUserList: Output<String>?
        get() = javaResource.roUserList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Read and write the client list. When Protocol NFS is returned when the status is.
     */
    public val rwClientList: Output<String>?
        get() = javaResource.rwClientList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Read-write user list. When Protocol for Server Message Block (SMB) to go back to.
     */
    public val rwUserList: Output<String>?
        get() = javaResource.rwUserList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The NFS protocol user mapping of the gateway file share. Valid values: `none`, `root_squash`, `all_squash`, `all_anonymous`. Default value: `none`. **NOTE:** The attribute is valid when the attribute `protocol` is `NFS`.
     */
    public val squash: Output<String>
        get() = javaResource.squash().applyValue({ args0 -> args0 })

    /**
     * Whether to support the archive transparent read.
     */
    public val supportArchive: Output<Boolean>
        get() = javaResource.supportArchive().applyValue({ args0 -> args0 })

    /**
     * The set up gateway file share whether to enable transmission acceleration needs corresponding OSS Bucket enabled transport acceleration. **NOTE:** Gateway version >= 1.3.0 above support.
     */
    public val transferAcceleration: Output<Boolean>
        get() = javaResource.transferAcceleration().applyValue({ args0 -> args0 })

    /**
     * Whether to enable by Windows access list (requires AD domain) the permissions control. Default value: `false`. **NOTE:** The attribute is valid when the attribute `protocol` is `SMB`. Gateway version >= 1.0.45 above support.
     */
    public val windowsAcl: Output<Boolean>
        get() = javaResource.windowsAcl().applyValue({ args0 -> args0 })
}

public object GatewayFileShareMapper : ResourceMapper<GatewayFileShare> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudstoragegateway.GatewayFileShare::class == javaResource::class

    override fun map(javaResource: Resource): GatewayFileShare = GatewayFileShare(
        javaResource as
            com.pulumi.alicloud.cloudstoragegateway.GatewayFileShare,
    )
}

/**
 * @see [GatewayFileShare].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewayFileShare].
 */
public suspend fun gatewayFileShare(
    name: String,
    block: suspend GatewayFileShareResourceBuilder.() -> Unit,
): GatewayFileShare {
    val builder = GatewayFileShareResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewayFileShare].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewayFileShare(name: String): GatewayFileShare {
    val builder = GatewayFileShareResourceBuilder()
    builder.name(name)
    return builder.build()
}
