@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.alicloud.cloudstoragegateway.GatewayFileShareArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Storage Gateway Gateway File Share resource.
 * For information about Cloud Storage Gateway Gateway File Share and how to use it, see [What is Gateway File Share](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewayfileshare).
 * > **NOTE:** Available since v1.144.0.
 * ## Import
 * Cloud Storage Gateway Gateway File Share can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/gatewayFileShare:GatewayFileShare example <gateway_id>:<index_id>
 * ```
 * @property accessBasedEnumeration Whether to enable Windows ABE, the prime minister, need windowsAcl parameter is set to true in the entry into force of. Default value: `false`. **NOTE:** The attribute is valid when the attribute `protocol` is `SMB`. Gateway version >= 1.0.45 above support.
 * @property backendLimit The Max upload speed of the gateway file share. Unit: `MB/s`, 0 means unlimited. Value range: `0` ~ `1280`. Default value: `0`. **NOTE:** at the same time if you have to limit the maximum write speed, maximum upload speed is no less than the maximum write speed.
 * @property browsable The whether browsable of the gateway file share (that is, in the network neighborhood of whether you can find). The attribute is valid when the attribute `protocol` is `SMB`. Default value: `true`.
 * @property bypassCacheRead Direct reading OSS of the gateway file share.
 * @property cacheMode The set up gateway file share cache mode. Valid values: `Cache` or `Sync`. `Cache`: cached mode. `Sync`: replication mode are available. Default value: `Cache`.
 * @property directIo File sharing Whether to enable DirectIO (direct I/O mode for data transmission). Default value: `false`.
 * @property downloadLimit The maximum download speed of the gateway file share. Unit: `MB/s`. `0` means unlimited. Value range: `0` ~ `1280`. **NOTE:** only in copy mode and enable download file data can be set. only when the shared opens the reverse synchronization or acceded to by the speed synchronization Group when, this parameter will not take effect. Gateway version >= 1.3.0 above support.
 * @property fastReclaim The whether to enable Upload optimization of the gateway file share, which is suitable for data pure backup migration scenarios. Default value: `false`. **NOTE:** Gateway version >= 1.0.39 above support.
 * @property feLimit The maximum write speed of the gateway file share. Unit: `MB/s`, `0` means unlimited. Value range: `0` ~ `1280`. Default value: `0`.
 * @property gatewayFileShareName The name of the file share. Length from `1` to `255` characters can contain lowercase letters, digits, (.), (_) Or (-), at the same time, must start with a lowercase letter.
 * @property gatewayId The ID of the gateway.
 * @property ignoreDelete The whether to ignore deleted of the gateway file share. After the opening of the Gateway side delete file or delete cloud (OSS) corresponding to the file. Default value: `false`. **NOTE:** `ignore_delete` and `remote_sync` cannot be enabled simultaneously. Gateway version >= 1.0.40 above support.
 * @property inPlace The whether debris optimization of the gateway file share. Default value: `false`.
 * @property lagPeriod The synchronization delay, I.e. gateway local cache sync to Alibaba Cloud Object Storage Service (oss) of the delay time. Unit: `Seconds`. Value range: `5` ~ `120`. Default value: `5`. **NOTE:** Gateway version >= 1.0.40 above support.
 * @property localPath The cache disk inside the device name.
 * @property nfsV4Optimization The set up gateway file share NFS protocol, whether to enable NFS v4 optimization improve Mount Upload efficiency. Default value: `false`. **NOTE:** If it is enabled, NFS V3 cannot be mounted. The attribute is valid when the attribute `protocol` is `NFS`. Gateway version >= 1.2.0 above support.
 * @property ossBucketName The name of the OSS Bucket.
 * @property ossBucketSsl Whether they are using SSL connect to OSS Bucket.
 * @property ossEndpoint The gateway file share corresponds to the Object Storage SERVICE (OSS), Bucket Endpoint. **NOTE:** distinguish between intranet and internet Endpoint. We recommend that if the OSS Bucket and the gateway is in the same Region is use the RDS intranet IP Endpoint: `oss-cn-hangzhou-internal.aliyuncs.com`.
 * @property partialSyncPaths In part mode, the directory path group JSON format.
 * @property pathPrefix The subdirectory path under the object storage (OSS) bucket corresponding to the file share. If it is blank, it means the root directory of the bucket.
 * @property pollingInterval The reverse synchronization time intervals of the gateway file share. Value range: `15` ~ `36000`. **NOTE:** in copy mode + reverse synchronization is enabled Download file data, value range: `3600` ~ `36000`.
 * @property protocol Share types. Valid values: `SMB`, `NFS`.
 * @property remoteSync Whether to enable reverse synchronization of the gateway file share. Default value: `false`.
 * @property remoteSyncDownload Copy mode, whether to download the file data. Default value: `false`. **NOTE:** only when the attribute `remote_sync` is `true` or acceded to by the speed synchronization group, this parameter will not take effect.
 * @property roClientList File sharing NFS read-only client list (IP address or IP address range). Use commas (,) to separate multiple clients.
 * @property roUserList The read-only client list. When Protocol for Server Message Block (SMB) to go back to.
 * @property rwClientList Read and write the client list. When Protocol NFS is returned when the status is.
 * @property rwUserList Read-write user list. When Protocol for Server Message Block (SMB) to go back to.
 * @property squash The NFS protocol user mapping of the gateway file share. Valid values: `none`, `root_squash`, `all_squash`, `all_anonymous`. Default value: `none`. **NOTE:** The attribute is valid when the attribute `protocol` is `NFS`.
 * @property supportArchive Whether to support the archive transparent read.
 * @property transferAcceleration The set up gateway file share whether to enable transmission acceleration needs corresponding OSS Bucket enabled transport acceleration. **NOTE:** Gateway version >= 1.3.0 above support.
 * @property windowsAcl Whether to enable by Windows access list (requires AD domain) the permissions control. Default value: `false`. **NOTE:** The attribute is valid when the attribute `protocol` is `SMB`. Gateway version >= 1.0.45 above support.
 */
public data class GatewayFileShareArgs(
    public val accessBasedEnumeration: Output<Boolean>? = null,
    public val backendLimit: Output<Int>? = null,
    public val browsable: Output<Boolean>? = null,
    public val bypassCacheRead: Output<Boolean>? = null,
    public val cacheMode: Output<String>? = null,
    public val directIo: Output<Boolean>? = null,
    public val downloadLimit: Output<Int>? = null,
    public val fastReclaim: Output<Boolean>? = null,
    public val feLimit: Output<Int>? = null,
    public val gatewayFileShareName: Output<String>? = null,
    public val gatewayId: Output<String>? = null,
    public val ignoreDelete: Output<Boolean>? = null,
    public val inPlace: Output<Boolean>? = null,
    public val lagPeriod: Output<Int>? = null,
    public val localPath: Output<String>? = null,
    public val nfsV4Optimization: Output<Boolean>? = null,
    public val ossBucketName: Output<String>? = null,
    public val ossBucketSsl: Output<Boolean>? = null,
    public val ossEndpoint: Output<String>? = null,
    public val partialSyncPaths: Output<String>? = null,
    public val pathPrefix: Output<String>? = null,
    public val pollingInterval: Output<Int>? = null,
    public val protocol: Output<String>? = null,
    public val remoteSync: Output<Boolean>? = null,
    public val remoteSyncDownload: Output<Boolean>? = null,
    public val roClientList: Output<String>? = null,
    public val roUserList: Output<String>? = null,
    public val rwClientList: Output<String>? = null,
    public val rwUserList: Output<String>? = null,
    public val squash: Output<String>? = null,
    public val supportArchive: Output<Boolean>? = null,
    public val transferAcceleration: Output<Boolean>? = null,
    public val windowsAcl: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.GatewayFileShareArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.GatewayFileShareArgs =
        com.pulumi.alicloud.cloudstoragegateway.GatewayFileShareArgs.builder()
            .accessBasedEnumeration(accessBasedEnumeration?.applyValue({ args0 -> args0 }))
            .backendLimit(backendLimit?.applyValue({ args0 -> args0 }))
            .browsable(browsable?.applyValue({ args0 -> args0 }))
            .bypassCacheRead(bypassCacheRead?.applyValue({ args0 -> args0 }))
            .cacheMode(cacheMode?.applyValue({ args0 -> args0 }))
            .directIo(directIo?.applyValue({ args0 -> args0 }))
            .downloadLimit(downloadLimit?.applyValue({ args0 -> args0 }))
            .fastReclaim(fastReclaim?.applyValue({ args0 -> args0 }))
            .feLimit(feLimit?.applyValue({ args0 -> args0 }))
            .gatewayFileShareName(gatewayFileShareName?.applyValue({ args0 -> args0 }))
            .gatewayId(gatewayId?.applyValue({ args0 -> args0 }))
            .ignoreDelete(ignoreDelete?.applyValue({ args0 -> args0 }))
            .inPlace(inPlace?.applyValue({ args0 -> args0 }))
            .lagPeriod(lagPeriod?.applyValue({ args0 -> args0 }))
            .localPath(localPath?.applyValue({ args0 -> args0 }))
            .nfsV4Optimization(nfsV4Optimization?.applyValue({ args0 -> args0 }))
            .ossBucketName(ossBucketName?.applyValue({ args0 -> args0 }))
            .ossBucketSsl(ossBucketSsl?.applyValue({ args0 -> args0 }))
            .ossEndpoint(ossEndpoint?.applyValue({ args0 -> args0 }))
            .partialSyncPaths(partialSyncPaths?.applyValue({ args0 -> args0 }))
            .pathPrefix(pathPrefix?.applyValue({ args0 -> args0 }))
            .pollingInterval(pollingInterval?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .remoteSync(remoteSync?.applyValue({ args0 -> args0 }))
            .remoteSyncDownload(remoteSyncDownload?.applyValue({ args0 -> args0 }))
            .roClientList(roClientList?.applyValue({ args0 -> args0 }))
            .roUserList(roUserList?.applyValue({ args0 -> args0 }))
            .rwClientList(rwClientList?.applyValue({ args0 -> args0 }))
            .rwUserList(rwUserList?.applyValue({ args0 -> args0 }))
            .squash(squash?.applyValue({ args0 -> args0 }))
            .supportArchive(supportArchive?.applyValue({ args0 -> args0 }))
            .transferAcceleration(transferAcceleration?.applyValue({ args0 -> args0 }))
            .windowsAcl(windowsAcl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayFileShareArgs].
 */
@PulumiTagMarker
public class GatewayFileShareArgsBuilder internal constructor() {
    private var accessBasedEnumeration: Output<Boolean>? = null

    private var backendLimit: Output<Int>? = null

    private var browsable: Output<Boolean>? = null

    private var bypassCacheRead: Output<Boolean>? = null

    private var cacheMode: Output<String>? = null

    private var directIo: Output<Boolean>? = null

    private var downloadLimit: Output<Int>? = null

    private var fastReclaim: Output<Boolean>? = null

    private var feLimit: Output<Int>? = null

    private var gatewayFileShareName: Output<String>? = null

    private var gatewayId: Output<String>? = null

    private var ignoreDelete: Output<Boolean>? = null

    private var inPlace: Output<Boolean>? = null

    private var lagPeriod: Output<Int>? = null

    private var localPath: Output<String>? = null

    private var nfsV4Optimization: Output<Boolean>? = null

    private var ossBucketName: Output<String>? = null

    private var ossBucketSsl: Output<Boolean>? = null

    private var ossEndpoint: Output<String>? = null

    private var partialSyncPaths: Output<String>? = null

    private var pathPrefix: Output<String>? = null

    private var pollingInterval: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var remoteSync: Output<Boolean>? = null

    private var remoteSyncDownload: Output<Boolean>? = null

    private var roClientList: Output<String>? = null

    private var roUserList: Output<String>? = null

    private var rwClientList: Output<String>? = null

    private var rwUserList: Output<String>? = null

    private var squash: Output<String>? = null

    private var supportArchive: Output<Boolean>? = null

    private var transferAcceleration: Output<Boolean>? = null

    private var windowsAcl: Output<Boolean>? = null

    /**
     * @param value Whether to enable Windows ABE, the prime minister, need windowsAcl parameter is set to true in the entry into force of. Default value: `false`. **NOTE:** The attribute is valid when the attribute `protocol` is `SMB`. Gateway version >= 1.0.45 above support.
     */
    @JvmName("prsfkgrsutwrdkss")
    public suspend fun accessBasedEnumeration(`value`: Output<Boolean>) {
        this.accessBasedEnumeration = value
    }

    /**
     * @param value The Max upload speed of the gateway file share. Unit: `MB/s`, 0 means unlimited. Value range: `0` ~ `1280`. Default value: `0`. **NOTE:** at the same time if you have to limit the maximum write speed, maximum upload speed is no less than the maximum write speed.
     */
    @JvmName("jtjxdhqxjxnhefms")
    public suspend fun backendLimit(`value`: Output<Int>) {
        this.backendLimit = value
    }

    /**
     * @param value The whether browsable of the gateway file share (that is, in the network neighborhood of whether you can find). The attribute is valid when the attribute `protocol` is `SMB`. Default value: `true`.
     */
    @JvmName("hwptcryubmeyvrnm")
    public suspend fun browsable(`value`: Output<Boolean>) {
        this.browsable = value
    }

    /**
     * @param value Direct reading OSS of the gateway file share.
     */
    @JvmName("sjtuvmulxrpflhdv")
    public suspend fun bypassCacheRead(`value`: Output<Boolean>) {
        this.bypassCacheRead = value
    }

    /**
     * @param value The set up gateway file share cache mode. Valid values: `Cache` or `Sync`. `Cache`: cached mode. `Sync`: replication mode are available. Default value: `Cache`.
     */
    @JvmName("wulcydwvmogwnlte")
    public suspend fun cacheMode(`value`: Output<String>) {
        this.cacheMode = value
    }

    /**
     * @param value File sharing Whether to enable DirectIO (direct I/O mode for data transmission). Default value: `false`.
     */
    @JvmName("rjauobamuyybjtxu")
    public suspend fun directIo(`value`: Output<Boolean>) {
        this.directIo = value
    }

    /**
     * @param value The maximum download speed of the gateway file share. Unit: `MB/s`. `0` means unlimited. Value range: `0` ~ `1280`. **NOTE:** only in copy mode and enable download file data can be set. only when the shared opens the reverse synchronization or acceded to by the speed synchronization Group when, this parameter will not take effect. Gateway version >= 1.3.0 above support.
     */
    @JvmName("esjjqdsndohmadso")
    public suspend fun downloadLimit(`value`: Output<Int>) {
        this.downloadLimit = value
    }

    /**
     * @param value The whether to enable Upload optimization of the gateway file share, which is suitable for data pure backup migration scenarios. Default value: `false`. **NOTE:** Gateway version >= 1.0.39 above support.
     */
    @JvmName("mdmvsphygrrpxgpg")
    public suspend fun fastReclaim(`value`: Output<Boolean>) {
        this.fastReclaim = value
    }

    /**
     * @param value The maximum write speed of the gateway file share. Unit: `MB/s`, `0` means unlimited. Value range: `0` ~ `1280`. Default value: `0`.
     */
    @JvmName("bkiqbhwjapeitbsj")
    public suspend fun feLimit(`value`: Output<Int>) {
        this.feLimit = value
    }

    /**
     * @param value The name of the file share. Length from `1` to `255` characters can contain lowercase letters, digits, (.), (_) Or (-), at the same time, must start with a lowercase letter.
     */
    @JvmName("wjajppscwhfkaumy")
    public suspend fun gatewayFileShareName(`value`: Output<String>) {
        this.gatewayFileShareName = value
    }

    /**
     * @param value The ID of the gateway.
     */
    @JvmName("cmpktuvlcrmnjbrh")
    public suspend fun gatewayId(`value`: Output<String>) {
        this.gatewayId = value
    }

    /**
     * @param value The whether to ignore deleted of the gateway file share. After the opening of the Gateway side delete file or delete cloud (OSS) corresponding to the file. Default value: `false`. **NOTE:** `ignore_delete` and `remote_sync` cannot be enabled simultaneously. Gateway version >= 1.0.40 above support.
     */
    @JvmName("renruxkdrqhpbedv")
    public suspend fun ignoreDelete(`value`: Output<Boolean>) {
        this.ignoreDelete = value
    }

    /**
     * @param value The whether debris optimization of the gateway file share. Default value: `false`.
     */
    @JvmName("fqmckfvxcnegjwue")
    public suspend fun inPlace(`value`: Output<Boolean>) {
        this.inPlace = value
    }

    /**
     * @param value The synchronization delay, I.e. gateway local cache sync to Alibaba Cloud Object Storage Service (oss) of the delay time. Unit: `Seconds`. Value range: `5` ~ `120`. Default value: `5`. **NOTE:** Gateway version >= 1.0.40 above support.
     */
    @JvmName("xyfcocmbpdeomvqs")
    public suspend fun lagPeriod(`value`: Output<Int>) {
        this.lagPeriod = value
    }

    /**
     * @param value The cache disk inside the device name.
     */
    @JvmName("fvhlulhyqepkqqfo")
    public suspend fun localPath(`value`: Output<String>) {
        this.localPath = value
    }

    /**
     * @param value The set up gateway file share NFS protocol, whether to enable NFS v4 optimization improve Mount Upload efficiency. Default value: `false`. **NOTE:** If it is enabled, NFS V3 cannot be mounted. The attribute is valid when the attribute `protocol` is `NFS`. Gateway version >= 1.2.0 above support.
     */
    @JvmName("bapxmtgutdwcpflh")
    public suspend fun nfsV4Optimization(`value`: Output<Boolean>) {
        this.nfsV4Optimization = value
    }

    /**
     * @param value The name of the OSS Bucket.
     */
    @JvmName("hiefxsdakrpilqhx")
    public suspend fun ossBucketName(`value`: Output<String>) {
        this.ossBucketName = value
    }

    /**
     * @param value Whether they are using SSL connect to OSS Bucket.
     */
    @JvmName("fklgialrukxipoef")
    public suspend fun ossBucketSsl(`value`: Output<Boolean>) {
        this.ossBucketSsl = value
    }

    /**
     * @param value The gateway file share corresponds to the Object Storage SERVICE (OSS), Bucket Endpoint. **NOTE:** distinguish between intranet and internet Endpoint. We recommend that if the OSS Bucket and the gateway is in the same Region is use the RDS intranet IP Endpoint: `oss-cn-hangzhou-internal.aliyuncs.com`.
     */
    @JvmName("yiormptrfebmgata")
    public suspend fun ossEndpoint(`value`: Output<String>) {
        this.ossEndpoint = value
    }

    /**
     * @param value In part mode, the directory path group JSON format.
     */
    @JvmName("dfbphfuejlshwuea")
    public suspend fun partialSyncPaths(`value`: Output<String>) {
        this.partialSyncPaths = value
    }

    /**
     * @param value The subdirectory path under the object storage (OSS) bucket corresponding to the file share. If it is blank, it means the root directory of the bucket.
     */
    @JvmName("ugwwjlabahppomrg")
    public suspend fun pathPrefix(`value`: Output<String>) {
        this.pathPrefix = value
    }

    /**
     * @param value The reverse synchronization time intervals of the gateway file share. Value range: `15` ~ `36000`. **NOTE:** in copy mode + reverse synchronization is enabled Download file data, value range: `3600` ~ `36000`.
     */
    @JvmName("yhepevsesjeiwrjg")
    public suspend fun pollingInterval(`value`: Output<Int>) {
        this.pollingInterval = value
    }

    /**
     * @param value Share types. Valid values: `SMB`, `NFS`.
     */
    @JvmName("ppjawssbtsuhqknq")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Whether to enable reverse synchronization of the gateway file share. Default value: `false`.
     */
    @JvmName("qggysfsrorumjtym")
    public suspend fun remoteSync(`value`: Output<Boolean>) {
        this.remoteSync = value
    }

    /**
     * @param value Copy mode, whether to download the file data. Default value: `false`. **NOTE:** only when the attribute `remote_sync` is `true` or acceded to by the speed synchronization group, this parameter will not take effect.
     */
    @JvmName("uvveqfhwnpuddaeo")
    public suspend fun remoteSyncDownload(`value`: Output<Boolean>) {
        this.remoteSyncDownload = value
    }

    /**
     * @param value File sharing NFS read-only client list (IP address or IP address range). Use commas (,) to separate multiple clients.
     */
    @JvmName("rgsknxgfwpxmquuf")
    public suspend fun roClientList(`value`: Output<String>) {
        this.roClientList = value
    }

    /**
     * @param value The read-only client list. When Protocol for Server Message Block (SMB) to go back to.
     */
    @JvmName("unpmmncvxnatlyhk")
    public suspend fun roUserList(`value`: Output<String>) {
        this.roUserList = value
    }

    /**
     * @param value Read and write the client list. When Protocol NFS is returned when the status is.
     */
    @JvmName("oxhnqcqdswuucclg")
    public suspend fun rwClientList(`value`: Output<String>) {
        this.rwClientList = value
    }

    /**
     * @param value Read-write user list. When Protocol for Server Message Block (SMB) to go back to.
     */
    @JvmName("tvyselgqoykuddtf")
    public suspend fun rwUserList(`value`: Output<String>) {
        this.rwUserList = value
    }

    /**
     * @param value The NFS protocol user mapping of the gateway file share. Valid values: `none`, `root_squash`, `all_squash`, `all_anonymous`. Default value: `none`. **NOTE:** The attribute is valid when the attribute `protocol` is `NFS`.
     */
    @JvmName("jgyfkkobffurispg")
    public suspend fun squash(`value`: Output<String>) {
        this.squash = value
    }

    /**
     * @param value Whether to support the archive transparent read.
     */
    @JvmName("kbjjbchqmcehcjco")
    public suspend fun supportArchive(`value`: Output<Boolean>) {
        this.supportArchive = value
    }

    /**
     * @param value The set up gateway file share whether to enable transmission acceleration needs corresponding OSS Bucket enabled transport acceleration. **NOTE:** Gateway version >= 1.3.0 above support.
     */
    @JvmName("xnoawtcjportpfpq")
    public suspend fun transferAcceleration(`value`: Output<Boolean>) {
        this.transferAcceleration = value
    }

    /**
     * @param value Whether to enable by Windows access list (requires AD domain) the permissions control. Default value: `false`. **NOTE:** The attribute is valid when the attribute `protocol` is `SMB`. Gateway version >= 1.0.45 above support.
     */
    @JvmName("evagilcadhjiiwwb")
    public suspend fun windowsAcl(`value`: Output<Boolean>) {
        this.windowsAcl = value
    }

    /**
     * @param value Whether to enable Windows ABE, the prime minister, need windowsAcl parameter is set to true in the entry into force of. Default value: `false`. **NOTE:** The attribute is valid when the attribute `protocol` is `SMB`. Gateway version >= 1.0.45 above support.
     */
    @JvmName("jrjnoaxbimvmqbix")
    public suspend fun accessBasedEnumeration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessBasedEnumeration = mapped
    }

    /**
     * @param value The Max upload speed of the gateway file share. Unit: `MB/s`, 0 means unlimited. Value range: `0` ~ `1280`. Default value: `0`. **NOTE:** at the same time if you have to limit the maximum write speed, maximum upload speed is no less than the maximum write speed.
     */
    @JvmName("fknpmvjqqcjcpjxy")
    public suspend fun backendLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendLimit = mapped
    }

    /**
     * @param value The whether browsable of the gateway file share (that is, in the network neighborhood of whether you can find). The attribute is valid when the attribute `protocol` is `SMB`. Default value: `true`.
     */
    @JvmName("kphnmaakixunlvbe")
    public suspend fun browsable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.browsable = mapped
    }

    /**
     * @param value Direct reading OSS of the gateway file share.
     */
    @JvmName("fnfljiuljylluyeh")
    public suspend fun bypassCacheRead(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bypassCacheRead = mapped
    }

    /**
     * @param value The set up gateway file share cache mode. Valid values: `Cache` or `Sync`. `Cache`: cached mode. `Sync`: replication mode are available. Default value: `Cache`.
     */
    @JvmName("rfdvbuvpguohdjwc")
    public suspend fun cacheMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheMode = mapped
    }

    /**
     * @param value File sharing Whether to enable DirectIO (direct I/O mode for data transmission). Default value: `false`.
     */
    @JvmName("kmwlgkwqhobmwith")
    public suspend fun directIo(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directIo = mapped
    }

    /**
     * @param value The maximum download speed of the gateway file share. Unit: `MB/s`. `0` means unlimited. Value range: `0` ~ `1280`. **NOTE:** only in copy mode and enable download file data can be set. only when the shared opens the reverse synchronization or acceded to by the speed synchronization Group when, this parameter will not take effect. Gateway version >= 1.3.0 above support.
     */
    @JvmName("wwsmshmirtsvqtxf")
    public suspend fun downloadLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.downloadLimit = mapped
    }

    /**
     * @param value The whether to enable Upload optimization of the gateway file share, which is suitable for data pure backup migration scenarios. Default value: `false`. **NOTE:** Gateway version >= 1.0.39 above support.
     */
    @JvmName("vtbwjnetlsqaqihk")
    public suspend fun fastReclaim(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fastReclaim = mapped
    }

    /**
     * @param value The maximum write speed of the gateway file share. Unit: `MB/s`, `0` means unlimited. Value range: `0` ~ `1280`. Default value: `0`.
     */
    @JvmName("arbqafsgjhiiwwbg")
    public suspend fun feLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.feLimit = mapped
    }

    /**
     * @param value The name of the file share. Length from `1` to `255` characters can contain lowercase letters, digits, (.), (_) Or (-), at the same time, must start with a lowercase letter.
     */
    @JvmName("hnitouykblnfvvki")
    public suspend fun gatewayFileShareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayFileShareName = mapped
    }

    /**
     * @param value The ID of the gateway.
     */
    @JvmName("ochjflebmicuuael")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayId = mapped
    }

    /**
     * @param value The whether to ignore deleted of the gateway file share. After the opening of the Gateway side delete file or delete cloud (OSS) corresponding to the file. Default value: `false`. **NOTE:** `ignore_delete` and `remote_sync` cannot be enabled simultaneously. Gateway version >= 1.0.40 above support.
     */
    @JvmName("cmjngnsujearymtq")
    public suspend fun ignoreDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreDelete = mapped
    }

    /**
     * @param value The whether debris optimization of the gateway file share. Default value: `false`.
     */
    @JvmName("jtruodlimxnogxjh")
    public suspend fun inPlace(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inPlace = mapped
    }

    /**
     * @param value The synchronization delay, I.e. gateway local cache sync to Alibaba Cloud Object Storage Service (oss) of the delay time. Unit: `Seconds`. Value range: `5` ~ `120`. Default value: `5`. **NOTE:** Gateway version >= 1.0.40 above support.
     */
    @JvmName("yjfytxisqiuurncs")
    public suspend fun lagPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lagPeriod = mapped
    }

    /**
     * @param value The cache disk inside the device name.
     */
    @JvmName("gamcoqgexjcolrcb")
    public suspend fun localPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localPath = mapped
    }

    /**
     * @param value The set up gateway file share NFS protocol, whether to enable NFS v4 optimization improve Mount Upload efficiency. Default value: `false`. **NOTE:** If it is enabled, NFS V3 cannot be mounted. The attribute is valid when the attribute `protocol` is `NFS`. Gateway version >= 1.2.0 above support.
     */
    @JvmName("joljvpbodqfufoqc")
    public suspend fun nfsV4Optimization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsV4Optimization = mapped
    }

    /**
     * @param value The name of the OSS Bucket.
     */
    @JvmName("mdebwfeygwualvmw")
    public suspend fun ossBucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossBucketName = mapped
    }

    /**
     * @param value Whether they are using SSL connect to OSS Bucket.
     */
    @JvmName("hvkhqwwsbiynytpn")
    public suspend fun ossBucketSsl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossBucketSsl = mapped
    }

    /**
     * @param value The gateway file share corresponds to the Object Storage SERVICE (OSS), Bucket Endpoint. **NOTE:** distinguish between intranet and internet Endpoint. We recommend that if the OSS Bucket and the gateway is in the same Region is use the RDS intranet IP Endpoint: `oss-cn-hangzhou-internal.aliyuncs.com`.
     */
    @JvmName("booryuwujmfkhbjd")
    public suspend fun ossEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossEndpoint = mapped
    }

    /**
     * @param value In part mode, the directory path group JSON format.
     */
    @JvmName("gieihbountcjioeb")
    public suspend fun partialSyncPaths(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partialSyncPaths = mapped
    }

    /**
     * @param value The subdirectory path under the object storage (OSS) bucket corresponding to the file share. If it is blank, it means the root directory of the bucket.
     */
    @JvmName("xgigsupmbryabaax")
    public suspend fun pathPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathPrefix = mapped
    }

    /**
     * @param value The reverse synchronization time intervals of the gateway file share. Value range: `15` ~ `36000`. **NOTE:** in copy mode + reverse synchronization is enabled Download file data, value range: `3600` ~ `36000`.
     */
    @JvmName("khkygtfobbhycvvd")
    public suspend fun pollingInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pollingInterval = mapped
    }

    /**
     * @param value Share types. Valid values: `SMB`, `NFS`.
     */
    @JvmName("fceymqplvltsgmpd")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Whether to enable reverse synchronization of the gateway file share. Default value: `false`.
     */
    @JvmName("qsjepmgtusklqwph")
    public suspend fun remoteSync(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteSync = mapped
    }

    /**
     * @param value Copy mode, whether to download the file data. Default value: `false`. **NOTE:** only when the attribute `remote_sync` is `true` or acceded to by the speed synchronization group, this parameter will not take effect.
     */
    @JvmName("ufbuinfbjlayjoww")
    public suspend fun remoteSyncDownload(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteSyncDownload = mapped
    }

    /**
     * @param value File sharing NFS read-only client list (IP address or IP address range). Use commas (,) to separate multiple clients.
     */
    @JvmName("gmhneruejkhinyoh")
    public suspend fun roClientList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roClientList = mapped
    }

    /**
     * @param value The read-only client list. When Protocol for Server Message Block (SMB) to go back to.
     */
    @JvmName("llpofkxhgpldudvk")
    public suspend fun roUserList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roUserList = mapped
    }

    /**
     * @param value Read and write the client list. When Protocol NFS is returned when the status is.
     */
    @JvmName("ycpekxopsimftqvi")
    public suspend fun rwClientList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rwClientList = mapped
    }

    /**
     * @param value Read-write user list. When Protocol for Server Message Block (SMB) to go back to.
     */
    @JvmName("hjxmdptwwnvogalo")
    public suspend fun rwUserList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rwUserList = mapped
    }

    /**
     * @param value The NFS protocol user mapping of the gateway file share. Valid values: `none`, `root_squash`, `all_squash`, `all_anonymous`. Default value: `none`. **NOTE:** The attribute is valid when the attribute `protocol` is `NFS`.
     */
    @JvmName("ggvueoionucqqybj")
    public suspend fun squash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.squash = mapped
    }

    /**
     * @param value Whether to support the archive transparent read.
     */
    @JvmName("hjbuvuxfmmtubmia")
    public suspend fun supportArchive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportArchive = mapped
    }

    /**
     * @param value The set up gateway file share whether to enable transmission acceleration needs corresponding OSS Bucket enabled transport acceleration. **NOTE:** Gateway version >= 1.3.0 above support.
     */
    @JvmName("vjgluyspfdllnvav")
    public suspend fun transferAcceleration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transferAcceleration = mapped
    }

    /**
     * @param value Whether to enable by Windows access list (requires AD domain) the permissions control. Default value: `false`. **NOTE:** The attribute is valid when the attribute `protocol` is `SMB`. Gateway version >= 1.0.45 above support.
     */
    @JvmName("anaittwjbwxxfifq")
    public suspend fun windowsAcl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsAcl = mapped
    }

    internal fun build(): GatewayFileShareArgs = GatewayFileShareArgs(
        accessBasedEnumeration = accessBasedEnumeration,
        backendLimit = backendLimit,
        browsable = browsable,
        bypassCacheRead = bypassCacheRead,
        cacheMode = cacheMode,
        directIo = directIo,
        downloadLimit = downloadLimit,
        fastReclaim = fastReclaim,
        feLimit = feLimit,
        gatewayFileShareName = gatewayFileShareName,
        gatewayId = gatewayId,
        ignoreDelete = ignoreDelete,
        inPlace = inPlace,
        lagPeriod = lagPeriod,
        localPath = localPath,
        nfsV4Optimization = nfsV4Optimization,
        ossBucketName = ossBucketName,
        ossBucketSsl = ossBucketSsl,
        ossEndpoint = ossEndpoint,
        partialSyncPaths = partialSyncPaths,
        pathPrefix = pathPrefix,
        pollingInterval = pollingInterval,
        protocol = protocol,
        remoteSync = remoteSync,
        remoteSyncDownload = remoteSyncDownload,
        roClientList = roClientList,
        roUserList = roUserList,
        rwClientList = rwClientList,
        rwUserList = rwUserList,
        squash = squash,
        supportArchive = supportArchive,
        transferAcceleration = transferAcceleration,
        windowsAcl = windowsAcl,
    )
}
