@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GatewayLogging].
 */
@PulumiTagMarker
public class GatewayLoggingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayLoggingArgs = GatewayLoggingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayLoggingArgsBuilder.() -> Unit) {
        val builder = GatewayLoggingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GatewayLogging {
        val builtJavaResource =
            com.pulumi.alicloud.cloudstoragegateway.GatewayLogging(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GatewayLogging(builtJavaResource)
    }
}

/**
 * Provides a Cloud Storage Gateway Gateway Logging resource.
 * For information about Cloud Storage Gateway Gateway Logging and how to use it, see [What is Gateway Logging](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewaylogging).
 * > **NOTE:** Available since v1.144.0.
 * ## Import
 * Cloud Storage Gateway Gateway Logging can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/gatewayLogging:GatewayLogging example <gateway_id>
 * ```
 */
public class GatewayLogging internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudstoragegateway.GatewayLogging,
) : KotlinCustomResource(javaResource, GatewayLoggingMapper) {
    /**
     * The ID of the Gateway.
     */
    public val gatewayId: Output<String>
        get() = javaResource.gatewayId().applyValue({ args0 -> args0 })

    /**
     * The name of the Log Store.
     */
    public val slsLogstore: Output<String>
        get() = javaResource.slsLogstore().applyValue({ args0 -> args0 })

    /**
     * The name of the Project.
     */
    public val slsProject: Output<String>
        get() = javaResource.slsProject().applyValue({ args0 -> args0 })

    /**
     * The status of the resource. Valid values: `Enabled`, `Disable`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object GatewayLoggingMapper : ResourceMapper<GatewayLogging> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudstoragegateway.GatewayLogging::class == javaResource::class

    override fun map(javaResource: Resource): GatewayLogging = GatewayLogging(
        javaResource as
            com.pulumi.alicloud.cloudstoragegateway.GatewayLogging,
    )
}

/**
 * @see [GatewayLogging].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewayLogging].
 */
public suspend fun gatewayLogging(
    name: String,
    block: suspend GatewayLoggingResourceBuilder.() -> Unit,
): GatewayLogging {
    val builder = GatewayLoggingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewayLogging].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewayLogging(name: String): GatewayLogging {
    val builder = GatewayLoggingResourceBuilder()
    builder.name(name)
    return builder.build()
}
