@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.alicloud.cloudstoragegateway.GatewayLoggingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Storage Gateway Gateway Logging resource.
 * For information about Cloud Storage Gateway Gateway Logging and how to use it, see [What is Gateway Logging](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewaylogging).
 * > **NOTE:** Available since v1.144.0.
 * ## Import
 * Cloud Storage Gateway Gateway Logging can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/gatewayLogging:GatewayLogging example <gateway_id>
 * ```
 * @property gatewayId The ID of the Gateway.
 * @property slsLogstore The name of the Log Store.
 * @property slsProject The name of the Project.
 * @property status The status of the resource. Valid values: `Enabled`, `Disable`.
 */
public data class GatewayLoggingArgs(
    public val gatewayId: Output<String>? = null,
    public val slsLogstore: Output<String>? = null,
    public val slsProject: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.GatewayLoggingArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.GatewayLoggingArgs =
        com.pulumi.alicloud.cloudstoragegateway.GatewayLoggingArgs.builder()
            .gatewayId(gatewayId?.applyValue({ args0 -> args0 }))
            .slsLogstore(slsLogstore?.applyValue({ args0 -> args0 }))
            .slsProject(slsProject?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayLoggingArgs].
 */
@PulumiTagMarker
public class GatewayLoggingArgsBuilder internal constructor() {
    private var gatewayId: Output<String>? = null

    private var slsLogstore: Output<String>? = null

    private var slsProject: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The ID of the Gateway.
     */
    @JvmName("ouhpamepmoegsrvw")
    public suspend fun gatewayId(`value`: Output<String>) {
        this.gatewayId = value
    }

    /**
     * @param value The name of the Log Store.
     */
    @JvmName("liyioqwggoflvjwq")
    public suspend fun slsLogstore(`value`: Output<String>) {
        this.slsLogstore = value
    }

    /**
     * @param value The name of the Project.
     */
    @JvmName("ojcgttoooyphxvsu")
    public suspend fun slsProject(`value`: Output<String>) {
        this.slsProject = value
    }

    /**
     * @param value The status of the resource. Valid values: `Enabled`, `Disable`.
     */
    @JvmName("uejntxoxhkjyhvkh")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The ID of the Gateway.
     */
    @JvmName("fmaltlxgxcbxrqeo")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayId = mapped
    }

    /**
     * @param value The name of the Log Store.
     */
    @JvmName("nnfjbbpuiyxtwaec")
    public suspend fun slsLogstore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsLogstore = mapped
    }

    /**
     * @param value The name of the Project.
     */
    @JvmName("jxyssewygdjccarr")
    public suspend fun slsProject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsProject = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Enabled`, `Disable`.
     */
    @JvmName("xnatfriuxrglrksf")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): GatewayLoggingArgs = GatewayLoggingArgs(
        gatewayId = gatewayId,
        slsLogstore = slsLogstore,
        slsProject = slsProject,
        status = status,
    )
}
