@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GatewaySmbUser].
 */
@PulumiTagMarker
public class GatewaySmbUserResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewaySmbUserArgs = GatewaySmbUserArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewaySmbUserArgsBuilder.() -> Unit) {
        val builder = GatewaySmbUserArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GatewaySmbUser {
        val builtJavaResource =
            com.pulumi.alicloud.cloudstoragegateway.GatewaySmbUser(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GatewaySmbUser(builtJavaResource)
    }
}

/**
 * Provides a Cloud Storage Gateway Gateway SMB User resource.
 * For information about Cloud Storage Gateway Gateway SMB User and how to use it, see [What is Gateway SMB User](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewaysmbuser).
 * > **NOTE:** Available since v1.142.0.
 * ## Import
 * Cloud Storage Gateway Gateway SMB User can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/gatewaySmbUser:GatewaySmbUser example <gateway_id>:<username>
 * ```
 */
public class GatewaySmbUser internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudstoragegateway.GatewaySmbUser,
) : KotlinCustomResource(javaResource, GatewaySmbUserMapper) {
    /**
     * The Gateway ID of the Gateway SMB User.
     */
    public val gatewayId: Output<String>
        get() = javaResource.gatewayId().applyValue({ args0 -> args0 })

    /**
     * The password of the Gateway SMB User.
     */
    public val password: Output<String>
        get() = javaResource.password().applyValue({ args0 -> args0 })

    /**
     * The username of the Gateway SMB User.
     */
    public val username: Output<String>
        get() = javaResource.username().applyValue({ args0 -> args0 })
}

public object GatewaySmbUserMapper : ResourceMapper<GatewaySmbUser> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudstoragegateway.GatewaySmbUser::class == javaResource::class

    override fun map(javaResource: Resource): GatewaySmbUser = GatewaySmbUser(
        javaResource as
            com.pulumi.alicloud.cloudstoragegateway.GatewaySmbUser,
    )
}

/**
 * @see [GatewaySmbUser].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewaySmbUser].
 */
public suspend fun gatewaySmbUser(
    name: String,
    block: suspend GatewaySmbUserResourceBuilder.() -> Unit,
): GatewaySmbUser {
    val builder = GatewaySmbUserResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewaySmbUser].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewaySmbUser(name: String): GatewaySmbUser {
    val builder = GatewaySmbUserResourceBuilder()
    builder.name(name)
    return builder.build()
}
