@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.alicloud.cloudstoragegateway.GatewaySmbUserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Storage Gateway Gateway SMB User resource.
 * For information about Cloud Storage Gateway Gateway SMB User and how to use it, see [What is Gateway SMB User](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewaysmbuser).
 * > **NOTE:** Available since v1.142.0.
 * ## Import
 * Cloud Storage Gateway Gateway SMB User can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/gatewaySmbUser:GatewaySmbUser example <gateway_id>:<username>
 * ```
 * @property gatewayId The Gateway ID of the Gateway SMB User.
 * @property password The password of the Gateway SMB User.
 * @property username The username of the Gateway SMB User.
 */
public data class GatewaySmbUserArgs(
    public val gatewayId: Output<String>? = null,
    public val password: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.GatewaySmbUserArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.GatewaySmbUserArgs =
        com.pulumi.alicloud.cloudstoragegateway.GatewaySmbUserArgs.builder()
            .gatewayId(gatewayId?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewaySmbUserArgs].
 */
@PulumiTagMarker
public class GatewaySmbUserArgsBuilder internal constructor() {
    private var gatewayId: Output<String>? = null

    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The Gateway ID of the Gateway SMB User.
     */
    @JvmName("noxsksinudntbkhj")
    public suspend fun gatewayId(`value`: Output<String>) {
        this.gatewayId = value
    }

    /**
     * @param value The password of the Gateway SMB User.
     */
    @JvmName("froycncbpiocntdd")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The username of the Gateway SMB User.
     */
    @JvmName("eeibgnvwbxbajsav")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The Gateway ID of the Gateway SMB User.
     */
    @JvmName("ifsghuuccxujpcgb")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayId = mapped
    }

    /**
     * @param value The password of the Gateway SMB User.
     */
    @JvmName("lcdvaynepyppdlxn")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The username of the Gateway SMB User.
     */
    @JvmName("vstlbpxpafodqdif")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): GatewaySmbUserArgs = GatewaySmbUserArgs(
        gatewayId = gatewayId,
        password = password,
        username = username,
    )
}
