@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StorageBundle].
 */
@PulumiTagMarker
public class StorageBundleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageBundleArgs = StorageBundleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageBundleArgsBuilder.() -> Unit) {
        val builder = StorageBundleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StorageBundle {
        val builtJavaResource =
            com.pulumi.alicloud.cloudstoragegateway.StorageBundle(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageBundle(builtJavaResource)
    }
}

/**
 * Provides a Cloud Storage Gateway Storage Bundle resource.
 * For information about Cloud Storage Gateway Storage Bundle and how to use it, see [What is Storage Bundle](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/createstoragebundle).
 * > **NOTE:** Available since v1.116.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cloudstoragegateway.StorageBundle("example", {storageBundleName: "example_value"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cloudstoragegateway.StorageBundle("example", storage_bundle_name="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.CloudStorageGateway.StorageBundle("example", new()
 *     {
 *         StorageBundleName = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudstoragegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudstoragegateway.NewStorageBundle(ctx, "example", &cloudstoragegateway.StorageBundleArgs{
 * 			StorageBundleName: pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudstoragegateway.StorageBundle;
 * import com.pulumi.alicloud.cloudstoragegateway.StorageBundleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StorageBundle("example", StorageBundleArgs.builder()
 *             .storageBundleName("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cloudstoragegateway:StorageBundle
 *     properties:
 *       storageBundleName: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Storage Gateway Storage Bundle can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/storageBundle:StorageBundle example <id>
 * ```
 */
public class StorageBundle internal constructor(
    override val javaResource: com.pulumi.alicloud.cloudstoragegateway.StorageBundle,
) : KotlinCustomResource(javaResource, StorageBundleMapper) {
    /**
     * The description of storage bundle.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of storage bundle.
     */
    public val storageBundleName: Output<String>
        get() = javaResource.storageBundleName().applyValue({ args0 -> args0 })
}

public object StorageBundleMapper : ResourceMapper<StorageBundle> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cloudstoragegateway.StorageBundle::class == javaResource::class

    override fun map(javaResource: Resource): StorageBundle = StorageBundle(
        javaResource as
            com.pulumi.alicloud.cloudstoragegateway.StorageBundle,
    )
}

/**
 * @see [StorageBundle].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageBundle].
 */
public suspend fun storageBundle(
    name: String,
    block: suspend StorageBundleResourceBuilder.() -> Unit,
): StorageBundle {
    val builder = StorageBundleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageBundle].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageBundle(name: String): StorageBundle {
    val builder = StorageBundleResourceBuilder()
    builder.name(name)
    return builder.build()
}
