@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin

import com.pulumi.alicloud.cloudstoragegateway.StorageBundleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Storage Gateway Storage Bundle resource.
 * For information about Cloud Storage Gateway Storage Bundle and how to use it, see [What is Storage Bundle](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/createstoragebundle).
 * > **NOTE:** Available since v1.116.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cloudstoragegateway.StorageBundle("example", {storageBundleName: "example_value"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cloudstoragegateway.StorageBundle("example", storage_bundle_name="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.CloudStorageGateway.StorageBundle("example", new()
 *     {
 *         StorageBundleName = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cloudstoragegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudstoragegateway.NewStorageBundle(ctx, "example", &cloudstoragegateway.StorageBundleArgs{
 * 			StorageBundleName: pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cloudstoragegateway.StorageBundle;
 * import com.pulumi.alicloud.cloudstoragegateway.StorageBundleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StorageBundle("example", StorageBundleArgs.builder()
 *             .storageBundleName("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cloudstoragegateway:StorageBundle
 *     properties:
 *       storageBundleName: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Storage Gateway Storage Bundle can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cloudstoragegateway/storageBundle:StorageBundle example <id>
 * ```
 * @property description The description of storage bundle.
 * @property storageBundleName The name of storage bundle.
 */
public data class StorageBundleArgs(
    public val description: Output<String>? = null,
    public val storageBundleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.StorageBundleArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.StorageBundleArgs =
        com.pulumi.alicloud.cloudstoragegateway.StorageBundleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .storageBundleName(storageBundleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageBundleArgs].
 */
@PulumiTagMarker
public class StorageBundleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var storageBundleName: Output<String>? = null

    /**
     * @param value The description of storage bundle.
     */
    @JvmName("bsbmspxlseujxher")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of storage bundle.
     */
    @JvmName("afokuwciyxgkdesn")
    public suspend fun storageBundleName(`value`: Output<String>) {
        this.storageBundleName = value
    }

    /**
     * @param value The description of storage bundle.
     */
    @JvmName("lhyupebmfypmhrih")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of storage bundle.
     */
    @JvmName("tdltokocutfuygvb")
    public suspend fun storageBundleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageBundleName = mapped
    }

    internal fun build(): StorageBundleArgs = StorageBundleArgs(
        description = description,
        storageBundleName = storageBundleName,
    )
}
