@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs

import com.pulumi.alicloud.cloudstoragegateway.inputs.GetExpressSyncsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getExpressSyncs.
 * @property ids A list of Express Sync IDs.
 * @property nameRegex A regex string to filter results by Express Sync name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetExpressSyncsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.inputs.GetExpressSyncsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.inputs.GetExpressSyncsPlainArgs =
        com.pulumi.alicloud.cloudstoragegateway.inputs.GetExpressSyncsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExpressSyncsPlainArgs].
 */
@PulumiTagMarker
public class GetExpressSyncsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Express Sync IDs.
     */
    @JvmName("lgkqfxvjtgbuwwkk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Express Sync IDs.
     */
    @JvmName("xuyendvqntjxybvo")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Express Sync name.
     */
    @JvmName("ekapbhihwctqurrf")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ycmukkwmwqlrgssg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetExpressSyncsPlainArgs = GetExpressSyncsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
