@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs

import com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewayBlockVolumesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGatewayBlockVolumes.
 * @property gatewayId The Gateway ID.
 * @property ids A list of Gateway Block Volume IDs.
 * @property nameRegex A regex string to filter results by Gateway Block Volume name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of volume. Valid values:
 */
public data class GetGatewayBlockVolumesPlainArgs(
    public val gatewayId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: Int? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewayBlockVolumesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewayBlockVolumesPlainArgs =
        com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewayBlockVolumesPlainArgs.builder()
            .gatewayId(gatewayId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewayBlockVolumesPlainArgs].
 */
@PulumiTagMarker
public class GetGatewayBlockVolumesPlainArgsBuilder internal constructor() {
    private var gatewayId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: Int? = null

    /**
     * @param value The Gateway ID.
     */
    @JvmName("xmpwrxawxxemalgc")
    public suspend fun gatewayId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayId = mapped
    }

    /**
     * @param value A list of Gateway Block Volume IDs.
     */
    @JvmName("gcjtctuiethmkbtr")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Gateway Block Volume IDs.
     */
    @JvmName("tasxrhgersamxgnp")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Gateway Block Volume name.
     */
    @JvmName("lshmucmqhrhkrcua")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("vmsrfywllcneoidh")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of volume. Valid values:
     */
    @JvmName("ottpujittjwoovur")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetGatewayBlockVolumesPlainArgs = GetGatewayBlockVolumesPlainArgs(
        gatewayId = gatewayId ?: throw PulumiNullFieldException("gatewayId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
