@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs

import com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewayCacheDisksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGatewayCacheDisks.
 * @property gatewayId The ID of the gateway.
 * @property ids A list of Gateway Cache Disk IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values: `0`, `1`, `2`. `0`: Normal. `1`: Is about to expire. `2`: Has expired.
 */
public data class GetGatewayCacheDisksPlainArgs(
    public val gatewayId: String,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewayCacheDisksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewayCacheDisksPlainArgs =
        com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewayCacheDisksPlainArgs.builder()
            .gatewayId(gatewayId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewayCacheDisksPlainArgs].
 */
@PulumiTagMarker
public class GetGatewayCacheDisksPlainArgsBuilder internal constructor() {
    private var gatewayId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: Int? = null

    /**
     * @param value The ID of the gateway.
     */
    @JvmName("qnyisdbtrulcijrd")
    public suspend fun gatewayId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayId = mapped
    }

    /**
     * @param value A list of Gateway Cache Disk IDs.
     */
    @JvmName("ubptiyekpkxnlbjh")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Gateway Cache Disk IDs.
     */
    @JvmName("bsllgfrrhwwiowlv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("juymaragxykawwkk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `0`, `1`, `2`. `0`: Normal. `1`: Is about to expire. `2`: Has expired.
     */
    @JvmName("cquoifvokgvasbnq")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetGatewayCacheDisksPlainArgs = GetGatewayCacheDisksPlainArgs(
        gatewayId = gatewayId ?: throw PulumiNullFieldException("gatewayId"),
        ids = ids,
        outputFile = outputFile,
        status = status,
    )
}
