@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs

import com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewaySmbUsersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGatewaySmbUsers.
 * @property gatewayId The Gateway ID.
 * @property ids A list of Gateway SMB User IDs.
 * @property nameRegex A regex string to filter results by Gateway SMB username.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetGatewaySmbUsersPlainArgs(
    public val gatewayId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewaySmbUsersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewaySmbUsersPlainArgs = com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewaySmbUsersPlainArgs.builder()
        .gatewayId(gatewayId.let({ args0 -> args0 }))
        .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
        .nameRegex(nameRegex?.let({ args0 -> args0 }))
        .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewaySmbUsersPlainArgs].
 */
@PulumiTagMarker
public class GetGatewaySmbUsersPlainArgsBuilder internal constructor() {
    private var gatewayId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The Gateway ID.
     */
    @JvmName("nmcckthjgssywahr")
    public suspend fun gatewayId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayId = mapped
    }

    /**
     * @param value A list of Gateway SMB User IDs.
     */
    @JvmName("yjgjqxkyasxllble")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Gateway SMB User IDs.
     */
    @JvmName("miwppbmspmgmwdux")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Gateway SMB username.
     */
    @JvmName("ooupixyahtdqyhbu")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("fyvyensgynsathds")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetGatewaySmbUsersPlainArgs = GetGatewaySmbUsersPlainArgs(
        gatewayId = gatewayId ?: throw PulumiNullFieldException("gatewayId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
