@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs

import com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewaysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGateways.
 * @property ids A list of Gateway IDs.
 * @property nameRegex A regex string to filter results by Gateway name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property status gateway status.
 * @property storageBundleId storage bundle id.
 */
public data class GetGatewaysPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
    public val storageBundleId: String,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewaysPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewaysPlainArgs =
        com.pulumi.alicloud.cloudstoragegateway.inputs.GetGatewaysPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .storageBundleId(storageBundleId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewaysPlainArgs].
 */
@PulumiTagMarker
public class GetGatewaysPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var status: String? = null

    private var storageBundleId: String? = null

    /**
     * @param value A list of Gateway IDs.
     */
    @JvmName("weasrdppjlvaqges")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Gateway IDs.
     */
    @JvmName("ylrtosimyeoopxcy")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Gateway name.
     */
    @JvmName("saapdlqwsihnilqo")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kircmofsxhjtxwjy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("nqwrpiokkfeacleb")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("tnmwffgxltqjpnru")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value gateway status.
     */
    @JvmName("wdqqwhrqqwebnruo")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value storage bundle id.
     */
    @JvmName("idhcerndyocvthnt")
    public suspend fun storageBundleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageBundleId = mapped
    }

    internal fun build(): GetGatewaysPlainArgs = GetGatewaysPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        status = status,
        storageBundleId = storageBundleId ?: throw PulumiNullFieldException("storageBundleId"),
    )
}
