@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs

import com.pulumi.alicloud.cloudstoragegateway.inputs.GetStocksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getStocks.
 * @property gatewayClass The gateway class. Valid values: `Basic`, `Standard`,`Enhanced`,`Advanced`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetStocksPlainArgs(
    public val gatewayClass: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.inputs.GetStocksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.inputs.GetStocksPlainArgs =
        com.pulumi.alicloud.cloudstoragegateway.inputs.GetStocksPlainArgs.builder()
            .gatewayClass(gatewayClass?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStocksPlainArgs].
 */
@PulumiTagMarker
public class GetStocksPlainArgsBuilder internal constructor() {
    private var gatewayClass: String? = null

    private var outputFile: String? = null

    /**
     * @param value The gateway class. Valid values: `Basic`, `Standard`,`Enhanced`,`Advanced`.
     */
    @JvmName("xgfgaxqqrhvvxivl")
    public suspend fun gatewayClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.gatewayClass = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kyjrvqbwsuhgvbge")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetStocksPlainArgs = GetStocksPlainArgs(
        gatewayClass = gatewayClass,
        outputFile = outputFile,
    )
}
